/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.Aquarium;
import org.mule.test.petstore.extension.ExclusiveCashier;
import org.mule.test.petstore.extension.ExclusivePetBreeder;
import org.mule.test.petstore.extension.PetStoreDeal;

public class PetStoreExclusiveParameterRequiredWithNullExpressionTestCase
extends AbstractExtensionFunctionalTestCase {
    private final String TEST_VALUE = "TEST";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private ConfigurationProperties configProperties;

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            public void doConfigure(MuleContext muleContext) throws ConfigurationException {
                ((ConfigurationProperties)Mockito.doReturn(Optional.empty()).when((Object)PetStoreExclusiveParameterRequiredWithNullExpressionTestCase.this.configProperties)).resolveBooleanProperty(ArgumentMatchers.anyString());
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConfigurationAttributesResolver", (Object)PetStoreExclusiveParameterRequiredWithNullExpressionTestCase.this.configProperties);
            }
        });
        super.addBuilders(builders);
    }

    protected String getConfigFile() {
        return "validation/petstore-exclusive-parameters-required-with-null-expression.xml";
    }

    @Test
    public void getBreederOperationFail() throws Exception {
        ((FlowRunner)this.flowRunner("getBreederOperation").withVariable("mammals", null)).runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Required parameters need to be assigned with non null values")));
    }

    @Test
    public void getBreederOperationSuccess() throws Exception {
        ExclusivePetBreeder exclusivePetBreeder = (ExclusivePetBreeder)((FlowRunner)this.flowRunner("getBreederOperation").withVariable("mammals", (Object)"TEST")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)exclusivePetBreeder.getunaliasedNammals(), (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void getAquariumOperationFail() throws Exception {
        ((FlowRunner)this.flowRunner("getAquariumOperation").withVariable("frogName", null)).runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Required parameters need to be assigned with non null values")));
    }

    @Test
    public void getAquariumOperationSuccess() throws Exception {
        Aquarium aquarium = (Aquarium)((FlowRunner)this.flowRunner("getAquariumOperation").withVariable("frogName", (Object)"TEST")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)aquarium.getPond().getFrogName(), (Matcher)Matchers.is((Object)"TEST"));
    }

    @Test
    public void getCashierOperationSucess() throws Exception {
        ExclusiveCashier cashier = (ExclusiveCashier)((FlowRunner)this.flowRunner("getCashierOperation").withVariable("pensionPlan", null)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)cashier.getDebt(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)cashier.getMoney(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)cashier.getPensionPlan(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)cashier.getRothIRA(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void getPetStoreDealOperation() throws Exception {
        PetStoreDeal petStoreDeal = (PetStoreDeal)((FlowRunner)this.flowRunner("getPetStoreDealOperation").withVariable("pensionPlan", null)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)petStoreDeal.getCashier().getPensionPlan(), (Matcher)Matchers.nullValue());
    }
}

