/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.metadata.extension.LocationKey;
import org.mule.test.metadata.extension.model.animals.AnimalClade;
import org.mule.test.module.extension.metadata.AbstractMetadataOperationTestCase;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class RuntimeMetadataTestCase
extends AbstractMetadataOperationTestCase {
    public RuntimeMetadataTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
    }

    @Override
    public boolean enableLazyInit() {
        return false;
    }

    @Override
    public boolean disableXmlValidations() {
        return false;
    }

    protected String getConfigFile() {
        return "metadata-runtime-tests.xml";
    }

    @Test
    public void injectComposedMetadataKeyIdInstanceInOperation() throws Exception {
        LocationKey payload = (LocationKey)this.flowRunner("simpleMultiLevelKeyResolver").run().getMessage().getPayload().getValue();
        LocationKey expected = new LocationKey();
        expected.setContinent("AMERICA");
        expected.setCountry("USA");
        expected.setCity("SFO");
        Assert.assertThat((Object)payload, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void injectSimpleMetadataKeyIdInOperation() throws Exception {
        String metadataKey = (String)this.flowRunner("outputOnlyWithoutContentParam").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)metadataKey, (Matcher)Is.is((Object)"PERSON"));
    }

    @Test
    public void injectTranslatedNativeQuery() throws Exception {
        CoreEvent event = this.flowRunner("queryOperation").run();
        String nativeQuery = (String)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)nativeQuery, (Matcher)Is.is((Object)"SELECT FIELDS: field-id FROM TYPE: Circle DO WHERE field-diameter < 18"));
    }

    @Test
    public void injectNonTranslatedNativeQuery() throws Exception {
        CoreEvent event = this.flowRunner("nativeQueryOperation").run();
        String nativeQuery = (String)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)nativeQuery.trim(), (Matcher)Is.is((Object)"SELECT FIELDS: field-id FROM TYPE: Circle DO WHERE field-diameter < 18"));
    }

    @Test
    public void enumMetadataKey() throws Exception {
        CoreEvent event = this.flowRunner("enumMetadataKey").run();
        AnimalClade key = (AnimalClade)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)key, (Matcher)Is.is((Object)AnimalClade.MAMMAL));
    }

    @Test
    public void booleanMetadataKey() throws Exception {
        CoreEvent event = this.flowRunner("booleanMetadataKey").run();
        boolean key = (Boolean)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)key, (Matcher)Is.is((Object)true));
    }

    @Test
    public void metadataKeyDefaultValue() throws Exception {
        CoreEvent event = this.flowRunner("metadataKeyDefaultValue").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"CAR"));
    }

    @Test
    public void queryWithExpression() throws Exception {
        List result = (List)((FlowRunner)this.flowRunner("queryWithExpression").withVariable("diameter", (Object)18)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo((Object)"SELECT FIELDS: field-id FROM TYPE: Circle DO WHERE field-diameter < 18"));
    }

    @Test
    public void injectComposedMetadataKeyIdInstanceInSource() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("sourceMetadataWithMultilevel");
        flow.start();
        flow.stop();
    }

    @Test
    public void injectSimpleMetadataKeyIdInstanceInSource() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("sourceMetadata");
        flow.start();
        flow.stop();
    }
}

