/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.io.InputStream;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.sdk.api.runtime.parameter.ParameterResolver;
import org.mule.tck.junit4.matcher.IsEmptyOptional;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.module.extension.parameter.resolver.AbstractParameterResolverTestCase;
import org.mule.test.parameter.resolver.extension.extension.NestedWrapperTypesConfig;
import org.mule.test.parameter.resolver.extension.extension.PojoWithStackableTypes;

public class StackableTypesTestCase
extends AbstractParameterResolverTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"nested-wrapper-types.xml"};
    }

    @Override
    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void configurationWithDynamicParameterResolvers() throws Exception {
        NestedWrapperTypesConfig config = (NestedWrapperTypesConfig)this.getPayload("configurationWithDynamicParameterResolvers");
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver doorResolver = config.getDoorResolver();
        TypedValue doorTypedValue = (TypedValue)doorResolver.resolve();
        KnockeableDoor door = (KnockeableDoor)doorTypedValue.getValue();
        MatcherAssert.assertThat((Object)door.getVictim(), (Matcher)CoreMatchers.is((Object)"Victim's Name"));
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver lazyParameter = config.getLazyParameter();
        Optional expression = lazyParameter.getExpression();
        TypedValue resolve = (TypedValue)lazyParameter.resolve();
        InputStream value = (InputStream)resolve.getValue();
        String stringValue = IOUtils.toString((InputStream)value);
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat(expression.get(), (Matcher)CoreMatchers.is((Object)"#[output application/json --- {key : 'a nice looking json'}]"));
        MatcherAssert.assertThat((Object)stringValue, (Matcher)CoreMatchers.is((Object)"{\n  \"key\": \"a nice looking json\"\n}"));
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver nestedParameter = config.getNestedParameter();
        TypedValue nestedTypedValue = (TypedValue)((org.mule.runtime.extension.api.runtime.parameter.ParameterResolver)((ParameterResolver)((org.mule.runtime.extension.api.runtime.parameter.ParameterResolver)nestedParameter.resolve()).resolve()).resolve()).resolve();
        InputStream nestedValue = (InputStream)nestedTypedValue.getValue();
        String nestedString = IOUtils.toString((InputStream)nestedValue);
        MatcherAssert.assertThat((Object)nestedString, (Matcher)CoreMatchers.is((Object)"{\n  \"key\": \"pretty nested\"\n}"));
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver resolverOfLiteral = config.getResolverOfLiteral();
        Literal stringLiteral = (Literal)resolverOfLiteral.resolve();
        Optional literalValue = stringLiteral.getLiteralValue();
        MatcherAssert.assertThat((Object)literalValue, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat(literalValue.get(), (Matcher)CoreMatchers.is((Object)"#['this doesn't make sense']"));
    }

    @Test
    public void configurationWithStaticParameterResolvers() throws Exception {
        NestedWrapperTypesConfig config = (NestedWrapperTypesConfig)this.getPayload("configurationWithStaticParameterResolvers");
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver doorResolver = config.getDoorResolver();
        TypedValue doorTypedValue = (TypedValue)doorResolver.resolve();
        KnockeableDoor door = (KnockeableDoor)doorTypedValue.getValue();
        MatcherAssert.assertThat((Object)door.getVictim(), (Matcher)CoreMatchers.is((Object)"Victim's Name"));
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver lazyParameter = config.getLazyString();
        Optional expression = lazyParameter.getExpression();
        TypedValue resolve = (TypedValue)lazyParameter.resolve();
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.is((Matcher)IsEmptyOptional.empty()));
        MatcherAssert.assertThat((Object)resolve.getValue(), (Matcher)CoreMatchers.is((Object)"a nice looking string"));
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver resolverOfLiteral = config.getResolverOfLiteral();
        Literal stringLiteral = (Literal)resolverOfLiteral.resolve();
        Optional literalValue = stringLiteral.getLiteralValue();
        MatcherAssert.assertThat((Object)literalValue, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat(literalValue.get(), (Matcher)CoreMatchers.is((Object)"this doesn't make sense"));
    }

    @Test
    public void parameterResolverOfTypedValueOnOperation() throws Exception {
        org.mule.runtime.extension.api.runtime.parameter.ParameterResolver lazyValue = (org.mule.runtime.extension.api.runtime.parameter.ParameterResolver)this.flowRunner("parameterResolverOfTypedValueOnOperation").run().getMessage().getPayload().getValue();
        TypedValue resolve = (TypedValue)lazyValue.resolve();
        InputStream jsonValue = (InputStream)resolve.getValue();
        Optional expression = lazyValue.getExpression();
        String stringValue = IOUtils.toString((InputStream)jsonValue);
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsEmptyOptional.empty())));
        MatcherAssert.assertThat(expression.get(), (Matcher)CoreMatchers.is((Object)"#[output application/json --- {key : 'a nice looking json'}]"));
        MatcherAssert.assertThat((Object)stringValue, (Matcher)CoreMatchers.is((Object)"{\n  \"key\": \"a nice looking json\"\n}"));
    }

    @Test
    public void staticStackableTypesUsingMetadataTypes() throws Exception {
        PojoWithStackableTypes pojoWithStackableTypes = (PojoWithStackableTypes)this.flowRunner("staticStackableTypes").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat(pojoWithStackableTypes.getLiteralString().getLiteralValue().get(), (Matcher)CoreMatchers.is((Object)"some static string"));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getLiteralString().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.theInstance(String.class)));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getParameterResolverString().resolve(), (Matcher)CoreMatchers.is((Object)"some static string"));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getParameterResolverString().getExpression(), (Matcher)CoreMatchers.is((Matcher)IsEmptyOptional.empty()));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getTypedValueString().getValue(), (Matcher)CoreMatchers.is((Object)"some static string"));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getTypedValueString().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
    }

    @Test
    public void dynamicStackableTypesUsingMetadataTypes() throws Exception {
        PojoWithStackableTypes pojoWithStackableTypes = (PojoWithStackableTypes)this.flowRunner("dynamicStackableTypes").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat(pojoWithStackableTypes.getLiteralString().getLiteralValue().get(), (Matcher)CoreMatchers.is((Object)"#['some static string']"));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getLiteralString().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.theInstance(String.class)));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getParameterResolverString().resolve(), (Matcher)CoreMatchers.is((Object)"some static string"));
        MatcherAssert.assertThat(pojoWithStackableTypes.getParameterResolverString().getExpression().get(), (Matcher)CoreMatchers.is((Object)"#['some static string']"));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getTypedValueString().getValue(), (Matcher)CoreMatchers.is((Object)"some static string"));
        MatcherAssert.assertThat((Object)pojoWithStackableTypes.getTypedValueString().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
    }
}

