/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tck.junit4.matcher.ValueMatcher;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class OperationValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/operation-values.xml";
    }

    @Test
    public void singleOptions() throws Exception {
        Set<Value> channels = this.getValues("single-values-enabled-parameter", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void singleOptionsEnabledParameterWithConnection() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterWithConnection", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("connection1", "connection2", "connection3"));
    }

    @Test
    public void singleOptionsEnabledParameterWithConfiguration() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterWithConfiguration", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("config1", "config2", "config3"));
    }

    @Test
    public void singleOptionsEnabledParameterWithRequiredParameters() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterWithRequiredParameters", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:aString"));
    }

    @Test
    public void singleOptionsEnabledParameterWithRequiredParametersUsingExpressions() throws Exception {
        Set<Value> channels = this.getValues("singleOptionsEnabledParameterWithRequiredParametersUsingExpressions", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:aString"));
    }

    @Test
    public void singleOptionsEnabledParameterWithMissingRequiredParameters() throws Exception {
        ValueResult valueResult = this.getValueResult("singleOptionsEnabledParameterWithMissingRequiredParameters", "channels");
        MatcherAssert.assertThat((Object)valueResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ResolvingFailure)valueResult.getFailure().get()).getFailureCode(), (Matcher)CoreMatchers.is((Object)"MISSING_REQUIRED_PARAMETERS"));
    }

    @Test
    public void singleOptionsEnabledParameterWithOptionalParameter() throws Exception {
        Set<Value> channels = this.getValues("singleOptionsEnabledParameterWithOptionalParameter", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:null"));
    }

    @Test
    public void singleOptionsEnabledParameterInsideParameterGroup() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterInsideParameterGroup", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void singleOptionsEnabledParameterRequiresValuesOfParameterGroup() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterRequiresValuesOfParameterGroup", "values");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:aParam"));
    }

    @Test
    public void multiLevelOption() throws Exception {
        Set<Value> values = this.getValues("multiLevelValue", "values");
        ValueMatcher americaValue = ValueMatcher.valueWithId((String)"America").withDisplayName("America").withPartName("continent").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Argentina").withDisplayName("Argentina").withPartName("country").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Buenos Aires").withDisplayName("Buenos Aires").withPartName("city")})});
        MatcherAssert.assertThat(values, this.hasValues(americaValue));
    }

    @Test
    public void singleOptionsWithRequiredParameterWithAlias() throws Exception {
        Set<Value> channels = this.getValues("singleValuesWithRequiredParameterWithAlias", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("requiredString:dummyValue"));
    }

    @Test
    public void resolverGetsMuleContextInjection() throws Exception {
        Set<Value> values = this.getValues("resolverGetsMuleContextInjection", "channel");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("INJECTED!!!"));
    }

    @Test
    public void optionsInsideShowInDslGroup() throws Exception {
        Set<Value> values = this.getValues("valuesInsideShowInDslGroup", "values");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void optionsInsideShowInDslDynamicGroup() throws Exception {
        Set<Value> values = this.getValues("valuesInsideShowInDslDynamicGroup", "values");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void userErrorWhenResolvingValues() throws Exception {
        ValueResult result = this.getValueResult("withErrorValueProvider", "values");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ResolvingFailure resolvingFailure = (ResolvingFailure)result.getFailure().get();
        MatcherAssert.assertThat((Object)resolvingFailure.getFailureCode(), (Matcher)CoreMatchers.is((Object)"CUSTOM_ERROR"));
        MatcherAssert.assertThat((Object)resolvingFailure.getMessage(), (Matcher)CoreMatchers.is((Object)"Error!!!"));
    }

    @Test
    public void withBoundActingParameter() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundActingParameterWithAlias() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterWithAlias", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundActingParameterField() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterField", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundActingParameterFieldWithDot() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterFieldWithDot", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withTwoActingParameters() throws Exception {
        ValueResult result = this.getValueResult("withTwoActingParameters", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value", "Scalar value"));
    }

    @Test
    public void withTwoBoundActingParameters() throws Exception {
        ValueResult result = this.getValueResult("withTwoBoundActingParameters", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value", "Scalar value"));
    }

    @Test
    public void withBoundActingParameterToXmlTagContent() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterToXmlTagContent", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("This is the tag content"));
    }

    @Test
    public void withBoundActingParameterToXmlTagAttribute() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterToXmlTagAttribute", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("This is the attribute value"));
    }

    @Test
    public void withFourBoundActingParameters() throws Exception {
        ValueResult result = this.getValueResult("withFourBoundActingParameters", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat((Object)values, this.hasValues("Field1 Value", "Field2 Value", "Field3 Value", "Field4 Value"));
    }

    @Test
    public void withBoundActingParameterArray() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterArray", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)values, this.hasValues("One Value", "Another value", "Yet another value"));
    }

    @Test
    public void withPojoBoundActingParameter() throws Exception {
        ValueResult result = this.getValueResult("withPojoBoundActingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("MyPojo{pojoId='This is the pojo ID', pojoName='This is the pojo name', pojoNumber=23, pojoBoolean=true}"));
    }

    @Test
    public void withMapBoundActingParameter() throws Exception {
        ValueResult result = this.getValueResult("withMapBoundActingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat((Object)values, this.hasValues("pojoId : This is the pojo ID", "pojoName : This is the pojo name", "pojoNumber : 23", "pojoBoolean : true"));
    }

    @Test
    public void withMissingBoundActingParameter() throws Exception {
        ValueResult result = this.getValueResult("withMissingBoundActingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ResolvingFailure)result.getFailure().get()).getMessage(), (Matcher)CoreMatchers.is((Object)"Unable to retrieve values. There are missing required parameters for the resolution: [requiredValue(taken from: actingParameter.field)]"));
    }

    @Test
    public void withPojoFieldBoundActingParameterFieldExpression() throws Exception {
        ValueResult result = this.getValueResult("withPojoFieldBoundActingParameterFieldExpression", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("This is the pojo ID"));
    }

    @Test
    public void withPojoFieldBoundActingParameterFieldDsl() throws Exception {
        ValueResult result = this.getValueResult("withPojoFieldBoundActingParameterFieldDsl", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("This is the pojo ID"));
    }

    @Test
    public void withPojoFieldBoundIncompleteActingParameterFieldDsl() throws Exception {
        ValueResult result = this.getValueResult("withPojoFieldBoundIncompleteActingParameterFieldDsl", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("This is the pojo ID"));
    }

    @Test
    public void withBoundActingParameterEnum() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterEnum", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("ENUM_VALUE"));
    }

    @Test
    public void withBoundOptionalActingParameterPresent() throws Exception {
        ValueResult result = this.getValueResult("withBoundOptionalActingParameterPresent", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundOptionalActingParameter() throws Exception {
        ValueResult result = this.getValueResult("withBoundOptionalActingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Optional value ommited"));
    }

    @Test
    public void withBoundOptionalActingParameterFieldPresent() throws Exception {
        ValueResult result = this.getValueResult("withBoundOptionalActingParameterFieldPresent", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundOptionalActingParameterFieldMissingParameter() throws Exception {
        ValueResult result = this.getValueResult("withBoundOptionalActingParameterFieldMissingParameter", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Optional value ommited"));
    }

    @Test
    public void withBoundOptionalActingParameterFieldMissingField() throws Exception {
        ValueResult result = this.getValueResult("withBoundOptionalActingParameterFieldMissingField", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Optional value ommited"));
    }

    @Test
    public void withBoundOptionalActingParameterFieldMissingPath() throws Exception {
        ValueResult result = this.getValueResult("withBoundOptionalActingParameterFieldMissingPath", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Optional value ommited"));
    }

    @Test
    public void withBoundActingParameterFromContentField() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterFromContentField", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundActingParameterFromContentFieldWithExpression() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterFromContentFieldWithExpression", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundActingParameterFromXmlContentField() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterFromXmlContentField", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void withBoundActingParameterFromXmlContentFieldWithExpression() throws Exception {
        ValueResult result = this.getValueResult("withBoundActingParameterFromXmlContentFieldWithExpression", "parameterWithValues");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Set values = result.getValues();
        MatcherAssert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)values, this.hasValues("Acting parameter value"));
    }

    @Test
    public void singleValuesEnabledParameterWithMoreThanOneFieldValues() throws Exception {
        ValueResult result1 = this.getValueResult("singleValuesEnabledParameterWithMoreThanOneFieldValues", "body", "simple.path");
        MatcherAssert.assertThat((Object)result1.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)result1.getValues(), this.hasValues("channel1", "channel2", "channel3"));
        ValueResult result2 = this.getValueResult("singleValuesEnabledParameterWithMoreThanOneFieldValues", "body", "another.simple.path");
        MatcherAssert.assertThat((Object)result2.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)result2.getValues(), this.hasValues("FALSE"));
    }

    @Test
    public void singleValuesEnabledParameterWithOneFieldValues() throws Exception {
        ValueResult result = this.getValueResult("singleValuesEnabledParameterWithOneFieldValues", "body", "simple.path");
        MatcherAssert.assertThat((Object)result.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)result.getValues(), this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void parameterWithTwoFieldWithSameValues() throws Exception {
        ValueResult targetResult = this.getValueResult("parameterWithTwoFieldWithSameValues", "body", "target.channelId");
        ValueResult sourceResult = this.getValueResult("parameterWithTwoFieldWithSameValues", "body", "source.channelId");
        String targetPartName = "body.target.channelId";
        MatcherAssert.assertThat((Object)targetResult.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)targetResult.getValues(), this.hasValues(ValueMatcher.valueWithId((String)"channel1").withPartName(targetPartName), ValueMatcher.valueWithId((String)"channel2").withPartName(targetPartName), ValueMatcher.valueWithId((String)"channel3").withPartName(targetPartName)));
        String sourcePartName = "body.source.channelId";
        MatcherAssert.assertThat((Object)sourceResult.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)sourceResult.getValues(), this.hasValues(ValueMatcher.valueWithId((String)"channel1").withPartName(sourcePartName), ValueMatcher.valueWithId((String)"channel2").withPartName(sourcePartName), ValueMatcher.valueWithId((String)"channel3").withPartName(sourcePartName)));
    }

    @Test
    public void parameterWithMultiLevelFieldValues() throws Exception {
        Set<Value> values = this.getValues("parameterWithMultilevelFieldValue", "body", "location.continent");
        ValueMatcher americaValue = ValueMatcher.valueWithId((String)"America").withDisplayName("America").withPartName("body.location.continent").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Argentina").withDisplayName("Argentina").withPartName("body.location.country").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Buenos Aires").withDisplayName("Buenos Aires").withPartName("body.location.city")})});
        MatcherAssert.assertThat(values, this.hasValues(americaValue));
    }

    @Test
    public void parameterWithMultipleMultiLevelFieldValuesWithSameVP() throws Exception {
        Set<Value> values = this.getValues("parameterWithMultipleMultiLevelFieldValuesWithSameVP", "body", "target.location.continent");
        ValueMatcher americaValue = ValueMatcher.valueWithId((String)"America").withDisplayName("America").withPartName("body.target.location.continent").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Argentina").withDisplayName("Argentina").withPartName("body.target.location.country").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Buenos Aires").withDisplayName("Buenos Aires").withPartName("body.target.location.city")})});
        MatcherAssert.assertThat(values, this.hasValues(americaValue));
        Set<Value> otherValues = this.getValues("parameterWithMultipleMultiLevelFieldValuesWithSameVP", "body", "source.location.continent");
        ValueMatcher otherAmericaValue = ValueMatcher.valueWithId((String)"America").withDisplayName("America").withPartName("body.source.location.continent").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Argentina").withDisplayName("Argentina").withPartName("body.source.location.country").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Buenos Aires").withDisplayName("Buenos Aires").withPartName("body.source.location.city")})});
        MatcherAssert.assertThat(otherValues, this.hasValues(otherAmericaValue));
    }

    @Test
    public void actingParameterWithReservedName() throws Exception {
        Set<Value> channels = this.getValues("actingParameterWithReservedName", "parameterWithValues");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("typeValue"));
    }
}

