/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.module.extension.config.AbstractConfigParserTestCase;
import org.mule.test.subtypes.extension.CarDoor;
import org.mule.test.subtypes.extension.FinalPojo;
import org.mule.test.subtypes.extension.HouseDoor;
import org.mule.test.subtypes.extension.NoGlobalPojo;
import org.mule.test.subtypes.extension.NoReferencePojo;
import org.mule.test.subtypes.extension.ParentShape;
import org.mule.test.subtypes.extension.PojoForList;
import org.mule.test.subtypes.extension.Revolver;
import org.mule.test.subtypes.extension.Square;
import org.mule.test.subtypes.extension.SubTypesConnectorConnection;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.subtypes.extension.Triangle;
import org.mule.test.vegan.extension.VeganCookBook;

public class SubTypesMappingParserTestCase
extends AbstractConfigParserTestCase {
    @Override
    protected String getConfigFile() {
        return "subtypes-mapping.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void shapeRetriever() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("shapeRetriever").withPayload((Object)"")).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.instanceOf(ParentShape.class));
        ParentShape payload = (ParentShape)responseEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload.getArea(), (Matcher)Matchers.is((Object)16));
    }

    @Test
    public void doorRetriever() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("doorRetriever").withPayload((Object)"")).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.instanceOf(CarDoor.class));
        CarDoor payload = (CarDoor)responseEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload.getColor(), (Matcher)Matchers.is((Object)"blue"));
    }

    @Test
    public void configRetriever() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("configRetriever").withPayload((Object)"")).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.instanceOf(SubTypesMappingConnector.class));
        SubTypesMappingConnector payload = (SubTypesMappingConnector)responseEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload.getAbstractShape(), (Matcher)Matchers.instanceOf(Square.class));
        Assert.assertThat((Object)payload.getAbstractShape().getArea(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)payload.getExplicitSquare(), (Matcher)Matchers.instanceOf(Square.class));
        Assert.assertThat((Object)payload.getExplicitSquare().getArea(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)payload.getDoorInterface(), (Matcher)Matchers.instanceOf(CarDoor.class));
        Assert.assertThat((Object)payload.getFinalPojo(), (Matcher)Matchers.instanceOf(FinalPojo.class));
        Assert.assertThat((Object)payload.getRicin(), (Matcher)Matchers.instanceOf(Ricin.class));
        Assert.assertThat((Object)payload.getTriangle(), (Matcher)Matchers.instanceOf(Triangle.class));
        Assert.assertThat((Object)payload.getOnePojos(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)payload.getOnePojos(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(payload.getOnePojos().get(0), (Matcher)Matchers.instanceOf(PojoForList.class));
        Assert.assertThat((Object)((PojoForList)payload.getOnePojos().get(0)).getId(), (Matcher)Matchers.is((Object)"inner"));
        Assert.assertThat((Object)payload.getWeapons(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)payload.getWeapons(), (Matcher)Matchers.hasSize((int)4));
        this.assertRevolver(payload.getWeapons().get(0), 6);
        this.assertRicin(payload.getWeapons().get(1), 10L, "Krazy-8");
        this.assertRicin(payload.getWeapons().get(2), 20L, "Lidia");
        this.assertRevolver(payload.getWeapons().get(3), 0);
        Assert.assertThat((Object)payload.getWeaponMap(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat(payload.getWeaponMap().entrySet(), (Matcher)Matchers.hasSize((int)3));
        this.assertRicin(payload.getWeaponMap().get("ricinChild"), 20L, "Lidia");
        this.assertRevolver(payload.getWeaponMap().get("revolverChild"), 1);
        this.assertRevolver(payload.getWeaponMap().get("revolverMEL"), 0);
    }

    @Test
    public void connectionRetriever() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("connectionRetriever").withPayload((Object)"")).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.instanceOf(SubTypesConnectorConnection.class));
        SubTypesConnectorConnection payload = (SubTypesConnectorConnection)responseEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload.getDoor(), (Matcher)Matchers.instanceOf(HouseDoor.class));
        Assert.assertThat((Object)payload.getShape(), (Matcher)Matchers.instanceOf(Triangle.class));
        Assert.assertThat((Object)payload.getShape().getArea(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void subtypedAndConcreteParameters() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("subtypedAndConcreteParameters").withPayload((Object)"")).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.notNullValue());
        List payload = (List)responseEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)Matchers.hasSize((int)7));
        Assert.assertThat(payload.get(0), (Matcher)Matchers.instanceOf(ParentShape.class));
        Assert.assertThat((Object)((ParentShape)payload.get(0)).getArea(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(payload.get(1), (Matcher)Matchers.instanceOf(HouseDoor.class));
        Assert.assertThat((Object)((HouseDoor)payload.get(1)).isLocked(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat(payload.get(2), (Matcher)Matchers.instanceOf(FinalPojo.class));
        Assert.assertThat((Object)((FinalPojo)payload.get(2)).getSomeString(), (Matcher)Matchers.is((Object)"asChild"));
        Assert.assertThat(payload.get(3), (Matcher)Matchers.instanceOf(VeganCookBook.class));
        Assert.assertThat((Object)((VeganCookBook)payload.get(3)).getNumberOfPages(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat(payload.get(4), (Matcher)Matchers.instanceOf(Square.class));
        Assert.assertThat((Object)((Square)payload.get(4)).getSide(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)((Square)payload.get(4)).getArea(), (Matcher)Matchers.is((Object)16));
        Assert.assertThat(payload.get(5), (Matcher)Matchers.instanceOf(Triangle.class));
        Assert.assertThat((Object)((Triangle)payload.get(5)).getHeight(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)((Triangle)payload.get(5)).getArea(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(payload.get(6), (Matcher)Matchers.instanceOf(NoReferencePojo.class));
        Assert.assertThat((Object)((NoReferencePojo)payload.get(6)).getNumber(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((NoReferencePojo)payload.get(6)).getString(), (Matcher)Matchers.is((Object)"noRef"));
    }

    @Test
    public void subtypedAndConcreteParametersAsAttributes() throws Exception {
        CoreEvent responseEvent = ((FlowRunner)this.flowRunner("subtypedAndConcreteParametersAsAttributes").withPayload((Object)"")).run();
        Assert.assertThat((Object)responseEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.notNullValue());
        List payload = (List)responseEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)Matchers.hasSize((int)7));
        Assert.assertThat(payload.get(1), (Matcher)Matchers.instanceOf(CarDoor.class));
        Assert.assertThat((Object)((CarDoor)payload.get(1)).getColor(), (Matcher)Matchers.is((Object)"white"));
        Assert.assertThat(payload.get(5), (Matcher)Matchers.instanceOf(Triangle.class));
        Assert.assertThat((Object)((Triangle)payload.get(5)).getHeight(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)((Triangle)payload.get(5)).getArea(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void subtypeContributionToOtherExtension() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg("heisenberg");
        Assert.assertThat((Object)heisenberg, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List wildCardWeapons = heisenberg.getWildCardWeapons();
        Assert.assertThat((Object)wildCardWeapons, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)wildCardWeapons, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(wildCardWeapons.get(0), (Matcher)Matchers.instanceOf(Ricin.class));
        Assert.assertThat((Object)((Ricin)wildCardWeapons.get(0)).getMicrogramsPerKilo(), (Matcher)Matchers.is((Object)10L));
        Assert.assertThat((Object)((Ricin)wildCardWeapons.get(0)).getDestination(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)((Ricin)wildCardWeapons.get(0)).getDestination().getVictim(), (Matcher)Matchers.is((Object)"Krazy-8"));
        Assert.assertThat(wildCardWeapons.get(1), (Matcher)Matchers.instanceOf(Revolver.class));
        Assert.assertThat((Object)((Revolver)wildCardWeapons.get(1)).getBullets(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void mappedParamSource() throws Exception {
        try {
            ((Flow)this.getFlowConstruct("sourceWithParameterMapping")).start();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void duplicatedOperationParameterAndTypeNames() throws Exception {
        Object payload = this.flowRunner("duplicatedOperationParameterAndTypeNames").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)payload, (Matcher)Matchers.instanceOf(NoGlobalPojo.class));
    }

    @Test
    public void parseRevolver() throws Exception {
        Revolver revolver = (Revolver)this.registry.lookupByName("sledgeHammer's").get();
        Assert.assertThat((Object)revolver, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)revolver.getBullets(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void doorIsUsedInMapAndAlone() throws Exception {
        Map payload = (Map)this.flowRunner("pojoIsUsedInMapAndAlone").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)Matchers.hasKey((Matcher)Matchers.instanceOf(HouseDoor.class)));
        Assert.assertThat((Object)payload, (Matcher)Matchers.hasValue((Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Matcher)Matchers.is((Object)"leftDoor")), (Matcher)Matchers.hasValue((Matcher)Matchers.instanceOf(CarDoor.class)))));
        Assert.assertThat((Object)payload, (Matcher)Matchers.hasValue((Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Matcher)Matchers.is((Object)"rightDoor")), (Matcher)Matchers.hasValue((Matcher)Matchers.instanceOf(CarDoor.class)))));
    }

    @Test
    public void valuesAreCorrectlyParsedForPojosWithCommonNameInnerField() throws Exception {
        Object payload = this.flowRunner("pojosWithCommonNameInnerField").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)Matchers.is((Object)"pull2"));
    }

    private void assertRicin(Object payload, Long micrograms, String victim) {
        Assert.assertThat((Object)payload, (Matcher)Matchers.instanceOf(Ricin.class));
        Assert.assertThat((Object)((Ricin)payload).getMicrogramsPerKilo(), (Matcher)Matchers.is((Object)micrograms));
        Assert.assertThat((Object)((Ricin)payload).getDestination(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)((Ricin)payload).getDestination().getVictim(), (Matcher)Matchers.is((Object)victim));
    }

    private void assertRevolver(Object payload, int bullets) {
        Assert.assertThat((Object)payload, (Matcher)Matchers.instanceOf(Revolver.class));
        Assert.assertThat((Object)((Revolver)payload).getBullets(), (Matcher)Matchers.is((Object)bullets));
    }
}

