/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.invocation.InterceptedInvocation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.el.datetime.Date;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.internal.dsl.DefaultDslResolvingContext;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.config.ConfigurationDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.config.extension.SimpleExtension;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.tck.classlaoder.TestClassLoader;

public class ConfigurationDefinitionParserTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void typeConverterUsesTheClassloaderOfTheParser() throws Exception {
        List componentBuildingDefinitions;
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        TestClassLoader classLoader = (TestClassLoader)Mockito.spy((Object)this.getTestClassLoader());
        ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)currentClassLoader, (ClassLoader)classLoader);
        try {
            ComponentBuildingDefinition.Builder definitionBuilder = new ComponentBuildingDefinition.Builder().withIdentifier("test").withNamespace("namespace");
            DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext((ClassLoader)classLoader, DslResolvingContext.getDefault(Collections.emptySet()));
            DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(SimpleExtension.class, "1.0.0-dev");
            loader.declare((ExtensionLoadingContext)ctx);
            ExtensionModelFactory factory = new ExtensionModelFactory();
            ExtensionModel extensionModel = factory.create((ExtensionLoadingContext)ctx);
            ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModels().get(0);
            DefaultDslResolvingContext dslResolvingContext = new DefaultDslResolvingContext(Collections.singleton(extensionModel));
            DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)dslResolvingContext);
            ExtensionParsingContext extensionParsingContext = new ExtensionParsingContext(extensionModel);
            ConfigurationDefinitionParser configurationDefinitionParser = new ConfigurationDefinitionParser(definitionBuilder, extensionModel, configurationModel, dslSyntaxResolver, extensionParsingContext);
            componentBuildingDefinitions = configurationDefinitionParser.parse();
        }
        finally {
            ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)classLoader, (ClassLoader)currentClassLoader);
        }
        Optional typeConverter = ((ComponentBuildingDefinition)componentBuildingDefinitions.get(1)).getTypeConverter();
        int testClassLoaderInvocations = Mockito.mockingDetails((Object)classLoader).getInvocations().size();
        ((TypeConverter)typeConverter.get()).convert(null);
        List invocations = (List)Mockito.mockingDetails((Object)classLoader).getInvocations();
        String invocation = (String)((InterceptedInvocation)invocations.get(invocations.size() - 1)).getArgument(0);
        MatcherAssert.assertThat((Object)(testClassLoaderInvocations + 2), (Matcher)Matchers.is((Object)invocations.size()));
        MatcherAssert.assertThat((Object)invocation, (Matcher)Matchers.is((Object)"org.mule.runtime.core.internal.el.datetime.Date"));
    }

    private TestClassLoader getTestClassLoader() {
        TestClassLoader classLoader = new TestClassLoader(null);
        classLoader.addClass("java.util.Map", Map.class);
        classLoader.addClass("org.mule.runtime.core.internal.el.datetime.Date", Date.class);
        return classLoader;
    }
}

