/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.module.extension.config.AbstractConfigParserTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ParameterizedConfigParserTestCase
extends AbstractConfigParserTestCase {
    private static final String HEISENBERG_BYNAME = "heisenberg";
    private static final String HEISENBERG_PLACEHOLDERS = "heisenbergWithPlaceHolders";
    private static final String HEISENBERG_BYREF = "heisenbergByRef";
    private static final String HEISENBERG_EXPRESSION = "expressionHeisenberg";
    private static final String HEISENBERG_EXPRESSION_BYREF = "expressionHeisenbergByRef";
    private static final Long MICROGRAMS_PER_KILO = 22L;
    private static final String LIDIA = "Lidia";
    private static final String STEVIA_COFFE_SHOP = "Stevia coffe shop";
    private static final String POLLOS_HERMANOS = "pollos hermanos";
    private static final String GUSTAVO_FRING = "Gustavo Fring";
    private static final String KRAZY_8 = "Krazy-8";
    private static final String JESSE_S = "Jesse's";
    private static final String METHYLAMINE = "methylamine";
    private static final int METHYLAMINE_QUANTITY = 75;
    private static final String PSEUDOEPHEDRINE = "pseudoephedrine";
    private static final int PSEUDOEPHEDRINE_QUANTITY = 0;
    private static final String P2P = "P2P";
    private static final int P2P_QUANTITY = 25;
    private static final String HANK = "Hank";
    private static final String MONEY = "1000000";
    private static final String LAB_ADDRESS = "Pollos Hermanos";
    private static final String FIRST_ENDEVOUR = "Gray Matter Technologies";
    private static final int DEATH_YEAR = 2011;
    private static final HealthStatus INITIAL_HEALTH = HealthStatus.CANCER;
    private static final HealthStatus FINAL_HEALTH = HealthStatus.DEAD;
    @Parameterized.Parameter(value=0)
    public String testConfig;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({HEISENBERG_BYNAME}, {HEISENBERG_PLACEHOLDERS}, {HEISENBERG_BYREF}, {HEISENBERG_EXPRESSION}, {HEISENBERG_EXPRESSION_BYREF});
    }

    @Test
    public void config() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        this.assertHeisenbergConfig(heisenberg);
    }

    @Test
    public void injectedConfigName() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        Assert.assertThat((Object)heisenberg.getConfigName(), (Matcher)CoreMatchers.equalTo((Object)this.testConfig));
    }

    @Test
    public void sameInstanceForEquivalentEvent() throws Exception {
        CoreEvent event = null;
        try {
            event = this.getHeisenbergEvent();
            HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig, event);
            Assert.assertThat((Object)heisenberg, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.lookupHeisenberg(this.testConfig, event))));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void configWithExpressionFunctionIsSameInstanceForDifferentEvents() throws Exception {
        CoreEvent event = null;
        try {
            event = this.getHeisenbergEvent();
            CoreEvent anotherEvent = this.testEvent();
            HeisenbergExtension config = this.lookupHeisenberg(HEISENBERG_BYNAME, event);
            HeisenbergExtension anotherConfig = this.lookupHeisenberg(HEISENBERG_BYNAME, anotherEvent);
            Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)anotherConfig)));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void configWithExpressionFunctionStillDynamic() throws Exception {
        CoreEvent event = null;
        CoreEvent anotherEvent = null;
        try {
            event = this.getHeisenbergEvent();
            anotherEvent = CoreEvent.builder((CoreEvent)this.getHeisenbergEvent()).addVariable("age", (Object)40).build();
            HeisenbergExtension config = this.lookupHeisenberg(HEISENBERG_EXPRESSION, event);
            HeisenbergExtension anotherConfig = this.lookupHeisenberg(HEISENBERG_EXPRESSION, anotherEvent);
            Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)anotherConfig))));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
            if (anotherEvent != null) {
                ((BaseEventContext)anotherEvent.getContext()).success();
            }
        }
    }

    @Test
    public void lifecycle() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        Assert.assertThat((Object)heisenberg.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)heisenberg.getStart(), (Matcher)CoreMatchers.is((Object)1));
        muleContext.stop();
        muleContext.dispose();
        Assert.assertThat((Object)heisenberg.getStop(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)heisenberg.getDispose(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void dependenciesInjected() throws Exception {
        HeisenbergExtension heisenberg = this.lookupHeisenberg(this.testConfig);
        Assert.assertThat((Object)heisenberg.getExtensionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)muleContext.getExtensionManager())));
    }

    private void assertHeisenbergConfig(HeisenbergExtension heisenberg) {
        Assert.assertNotNull((Object)heisenberg);
        this.assertSimpleProperties(heisenberg);
        this.assertRecipe(heisenberg);
        this.assertDoors(heisenberg);
        this.assertRicinPacks(heisenberg);
        this.assertCandidateDoors(heisenberg);
        this.assertDeathsBySeason(heisenberg);
        this.assertMonthlyIncomes(heisenberg);
        this.assertLabeledRicin(heisenberg);
    }

    private void assertRicinPacks(HeisenbergExtension heisenberg) {
        Set ricinPacks = heisenberg.getRicinGroup().getRicinPacks();
        Assert.assertNotNull((Object)ricinPacks);
        Assert.assertThat((Object)ricinPacks.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Ricin ricin = (Ricin)ricinPacks.iterator().next();
        Assert.assertThat((Object)ricin.getMicrogramsPerKilo(), (Matcher)CoreMatchers.equalTo((Object)MICROGRAMS_PER_KILO));
        this.assertDoor(ricin.getDestination(), LIDIA, STEVIA_COFFE_SHOP);
    }

    private void assertDoors(HeisenbergExtension heisenberg) {
        KnockeableDoor door = heisenberg.getRicinGroup().getNextDoor();
        this.assertDoor(door, GUSTAVO_FRING, POLLOS_HERMANOS);
        KnockeableDoor previous = door.getPrevious();
        this.assertDoor(door.getPrevious(), KRAZY_8, JESSE_S);
        Assert.assertNull((Object)previous.getPrevious());
    }

    private void assertRecipe(HeisenbergExtension heisenberg) {
        Map recipe = heisenberg.getRecipe();
        Assert.assertNotNull((Object)recipe);
        Assert.assertThat((Object)recipe.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat(recipe.get(METHYLAMINE), (Matcher)CoreMatchers.equalTo((Object)75L));
        Assert.assertThat(recipe.get(PSEUDOEPHEDRINE), (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertThat(recipe.get(P2P), (Matcher)CoreMatchers.equalTo((Object)25L));
    }

    private void assertSimpleProperties(HeisenbergExtension heisenberg) {
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getName(), (Matcher)CoreMatchers.equalTo((Object)"Heisenberg"));
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getAge(), (Matcher)CoreMatchers.equalTo((Object)Integer.valueOf("50")));
        List enemies = heisenberg.getEnemies();
        Assert.assertThat((Object)enemies, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)enemies.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat(enemies.get(0), (Matcher)CoreMatchers.equalTo((Object)GUSTAVO_FRING));
        Assert.assertThat(enemies.get(1), (Matcher)CoreMatchers.equalTo((Object)HANK));
        Assert.assertTrue((boolean)heisenberg.isCancer());
        Assert.assertThat((Object)heisenberg.getInitialHealth(), (Matcher)CoreMatchers.is((Object)INITIAL_HEALTH));
        Assert.assertThat((Object)heisenberg.getEndingHealth(), (Matcher)CoreMatchers.is((Object)FINAL_HEALTH));
        Assert.assertThat((Object)heisenberg.getFirstEndevour(), (Matcher)Matchers.containsString((String)FIRST_ENDEVOUR));
        Assert.assertThat((Object)heisenberg.getLabAddress(), (Matcher)CoreMatchers.is((Object)LAB_ADDRESS));
        Calendar dayOfBirth = Calendar.getInstance();
        dayOfBirth.setTime(heisenberg.getPersonalInfo().getDateOfBirth());
        Assert.assertThat((Object)dayOfBirth.get(1), (Matcher)CoreMatchers.equalTo((Object)ParameterizedConfigParserTestCase.getDateOfBirth().get(1)));
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getDateOfDeath().get(1), (Matcher)CoreMatchers.equalTo((Object)ParameterizedConfigParserTestCase.getDateOfDeath().get(1)));
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getDateOfConception().getYear(), (Matcher)CoreMatchers.is((Object)ParameterizedConfigParserTestCase.getDateOfConception().getYear()));
        Assert.assertThat((Object)heisenberg.getPersonalInfo().getDateOfConception().getMonth(), (Matcher)CoreMatchers.is((Object)ParameterizedConfigParserTestCase.getDateOfConception().getMonth()));
        Assert.assertThat((Object)heisenberg.getMoney(), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(MONEY)));
    }

    private void assertCandidateDoors(HeisenbergExtension heisenberg) {
        Map candidates = heisenberg.getCandidateDoors();
        Assert.assertNotNull((Object)candidates);
        Assert.assertThat((Object)candidates.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertDoor((KnockeableDoor)candidates.get("Skyler".toLowerCase()), "Skyler", "308 Negra Arroyo Lane");
        this.assertDoor((KnockeableDoor)candidates.get("Saul".toLowerCase()), "Saul", "Shopping Mall");
    }

    private void assertDoor(KnockeableDoor door, String victim, String address) {
        Assert.assertNotNull((Object)door);
        Assert.assertThat((Object)door.getVictim(), (Matcher)CoreMatchers.equalTo((Object)victim));
        Assert.assertThat((Object)door.getAddress(), (Matcher)CoreMatchers.equalTo((Object)address));
    }

    public static Calendar getDateOfBirth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1959);
        calendar.set(2, 8);
        calendar.set(5, 7);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static LocalDateTime getDateOfConception() {
        return LocalDateTime.of(1959, Month.JANUARY, 7, 0, 0);
    }

    public static Calendar getDateOfDeath() {
        Calendar calendar = ParameterizedConfigParserTestCase.getDateOfBirth();
        calendar.set(1, 2011);
        return calendar;
    }

    private void assertLabeledRicin(HeisenbergExtension heisenberg) {
        Map labeledRicin = heisenberg.getRicinGroup().getLabeledRicin();
        Assert.assertNotNull((Object)labeledRicin);
        Assert.assertThat((Object)labeledRicin.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat(labeledRicin.get("pojo"), (Matcher)CoreMatchers.instanceOf(Ricin.class));
        Ricin ricin = (Ricin)labeledRicin.get("pojo");
        Assert.assertNotNull((Object)ricin);
        Assert.assertThat((Object)ricin.getMicrogramsPerKilo(), (Matcher)CoreMatchers.equalTo((Object)MICROGRAMS_PER_KILO));
        this.assertDoor(ricin.getDestination(), LIDIA, STEVIA_COFFE_SHOP);
    }

    private void assertMonthlyIncomes(HeisenbergExtension heisenberg) {
        List incomes = heisenberg.getMonthlyIncomes();
        Assert.assertNotNull((Object)incomes);
        Assert.assertThat((Object)incomes.size(), (Matcher)CoreMatchers.equalTo((Object)MONTHLY_INCOMES.size()));
        Assert.assertThat((Object)incomes, (Matcher)Matchers.containsInAnyOrder((Object[])MONTHLY_INCOMES.toArray()));
    }

    private void assertDeathsBySeason(HeisenbergExtension heisenberg) {
        Map deaths = heisenberg.getDeathsBySeasons();
        Assert.assertNotNull((Object)deaths);
        Assert.assertThat((Object)deaths.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        List s01 = (List)deaths.get("s01");
        Assert.assertNotNull((Object)s01);
        Assert.assertThat((Object)s01.size(), (Matcher)CoreMatchers.equalTo((Object)((List)DEATHS_BY_SEASON.get("s01")).size()));
        Assert.assertThat((Object)s01, (Matcher)Matchers.containsInAnyOrder((Object[])((List)DEATHS_BY_SEASON.get("s01")).toArray()));
        List s02 = (List)deaths.get("s02");
        Assert.assertNotNull((Object)s02);
        Assert.assertThat((Object)s02.size(), (Matcher)CoreMatchers.equalTo((Object)((List)DEATHS_BY_SEASON.get("s02")).size()));
        Assert.assertThat((Object)s02, (Matcher)Matchers.containsInAnyOrder((Object[])((List)DEATHS_BY_SEASON.get("s02")).toArray()));
    }
}

