/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.probe.PollingProber;
import org.mule.test.heisenberg.extension.ReconnectableHeisenbergSource;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Features(value={@Feature(value="Sources"), @Feature(value="Reconnection Policies")})
public class CustomReconnectionSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int TIMEOUT_MILLIS = 50000;
    public static final int POLL_DELAY_MILLIS = 100;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "source/custom-reconnection-source-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.reset();
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.reset();
    }

    @Test
    public void successfulCustomReconnection() throws Exception {
        this.startFlow("successfulCustomReconnection");
        PollingProber.probe((long)50000L, (long)100L, () -> ReconnectableHeisenbergSource.succesfulReconnections > 1);
        Assert.assertThat((Object)ReconnectableHeisenbergSource.failedReconnections, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void failingCustomReconnection() throws Exception {
        this.startFlow("failingCustomReconnection");
        PollingProber.probe((long)50000L, (long)100L, () -> ReconnectableHeisenbergSource.failedReconnections > 0);
        Assert.assertThat((Object)ReconnectableHeisenbergSource.succesfulReconnections, (Matcher)CoreMatchers.is((Object)0));
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    private void reset() {
        ReconnectableHeisenbergSource.succesfulReconnections = 0;
        ReconnectableHeisenbergSource.failedReconnections = 0;
    }
}

