/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.resources.manifest.ClassPackageFinder;
import org.mule.runtime.module.extension.internal.resources.manifest.DefaultClassPackageFinder;
import org.mule.runtime.module.extension.internal.resources.manifest.ExportedPackagesCollector;
import org.mule.runtime.module.extension.internal.resources.manifest.ProcessingEnvironmentClassPackageFinder;

public class ExportedPackagesValidator
implements ExtensionModelValidator {
    private static final String EXPORTED_PACKAGES_VALIDATOR_SKIP = "exportedPackagesValidator.skip";
    private static final String EXPORTED_PACKAGES_VALIDATOR_STRICT_VALIDATION = "exportedPackagesValidator.strictValidation";
    private ProcessingEnvironment processingEnv;

    public ExportedPackagesValidator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public ExportedPackagesValidator() {
    }

    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        if (this.shouldValidate()) {
            ExportedPackagesCollector exportedPackagesCollector = this.getExportedArtifactsCollector(model);
            Map exportedPackages = exportedPackagesCollector.getDetailedExportedPackages();
            HashMap<String, Collection<String>> internalPackages = new HashMap<String, Collection<String>>();
            HashMap<String, Collection<String>> noVisibilityDeclaredPackages = new HashMap<String, Collection<String>>();
            exportedPackages.forEach((packageName, classes) -> {
                if (!packageName.contains(".api.") && !packageName.endsWith(".api")) {
                    if (packageName.contains(".internal.") || packageName.endsWith(".internal")) {
                        internalPackages.put((String)packageName, (Collection<String>)classes);
                    } else {
                        noVisibilityDeclaredPackages.put((String)packageName, (Collection<String>)classes);
                    }
                }
            });
            if (!internalPackages.isEmpty()) {
                Problem problem = new Problem((NamedObject)model, this.getErrorMessage(model, internalPackages, "exports the following internal packages"));
                if (this.strictValidation()) {
                    problemsReporter.addError(problem);
                } else {
                    problemsReporter.addWarning(problem);
                }
            }
            if (!noVisibilityDeclaredPackages.isEmpty()) {
                problemsReporter.addWarning(new Problem((NamedObject)model, this.getErrorMessage(model, noVisibilityDeclaredPackages, "exports packages which doesn't have a defined visibility, 'api' or 'internal'")));
            }
        }
    }

    private String getErrorMessage(ExtensionModel model, Map<String, Collection<String>> packages, String message) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("The extension [").append(model.getName()).append("] ").append(message).append(":\n");
        packages.forEach((packageName, classes) -> {
            messageBuilder.append("-> [").append((String)packageName).append("]:").append(" because of these classes: \n");
            classes.forEach(clazz -> messageBuilder.append("        * ").append((String)clazz).append("\n"));
            messageBuilder.append("\n");
        });
        return messageBuilder.toString();
    }

    private boolean shouldValidate() {
        String skip = System.getProperty(EXPORTED_PACKAGES_VALIDATOR_SKIP);
        return skip == null || !Boolean.valueOf(skip).booleanValue();
    }

    private boolean strictValidation() {
        String strictValidation = System.getProperty(EXPORTED_PACKAGES_VALIDATOR_STRICT_VALIDATION);
        return strictValidation != null ? Boolean.valueOf(strictValidation) : true;
    }

    private ExportedPackagesCollector getExportedArtifactsCollector(ExtensionModel extensionModel) {
        if (this.processingEnv != null) {
            DefaultClassPackageFinder defaultClassPackageFinder = new DefaultClassPackageFinder();
            defaultClassPackageFinder.addAdditionalPackageFinder((ClassPackageFinder)new ProcessingEnvironmentClassPackageFinder(this.processingEnv));
            return new ExportedPackagesCollector(extensionModel, (ClassPackageFinder)defaultClassPackageFinder);
        }
        return new ExportedPackagesCollector(extensionModel);
    }
}

