/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.validation;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.vegan.extension.VeganExtension;

@Feature(value="Mule DSL")
@Story(value="Mule DSL Validations")
public class InvalidExtensionConfigTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void heisenbergMissingTls() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/heisenberg-missing-tls-connection-config.xml:17]: Element <heisenberg:secure-connection> is missing required parameter 'tlsContext'.");
        this.loadConfiguration("validation/heisenberg-missing-tls-connection-config.xml");
    }

    @Test
    public void heisenbergDefaultConfigNegative() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/heisenberg-default-illegal-config.xml:21]: Element <heisenberg:config> is missing required parameter 'knownAddresses'.");
        this.loadConfiguration("validation/heisenberg-default-illegal-config.xml");
    }

    @Test
    public void petStoreMissingRequiredParameterInsidePojo() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-missing-required-parameter.xml:17]: Element <petstore:phone-number> is missing required parameter 'areaCodes'.");
        this.loadConfiguration("validation/petstore-missing-required-parameter.xml");
    }

    @Test
    public void operationWithExpressionConfigReference() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/operation-with-expression-config-ref.xml:19]: Element <heisenberg:config> is missing required parameter 'knownAddresses'.");
        this.loadConfiguration("validation/operation-with-expression-config-ref.xml");
    }

    @Test
    public void sourceWithExpressionConfigReference() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/source-with-expression-config-ref.xml:20]: Element <heisenberg:config> is missing required parameter 'knownAddresses'.");
        this.loadConfiguration("validation/source-with-expression-config-ref.xml");
    }

    @Test
    public void petStoreExclusiveGroupPojo() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-exclusive-group-pojo-config.xml:8]: Element <config>, the following parameters cannot be set at the same time: [cash, debt].");
        this.loadConfiguration("validation/petstore-exclusive-group-pojo-config.xml");
    }

    @Test
    public void petStoreExclusiveGroupInsidePojo() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-exclusive-group-inside-pojo-config.xml:13]: Element <Aquarium>, the following parameters cannot be set at the same time: [frogName, fishName].");
        this.loadConfiguration("validation/petstore-exclusive-group-inside-pojo-config.xml");
    }

    @Test
    public void petStoreExclusiveParameterOperation() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-exclusive-parameters-operation.xml:16]: Element <getBreeder>, the following parameters cannot be set at the same time: [mammals, birds].");
        this.loadConfiguration("validation/petstore-exclusive-parameters-operation.xml");
    }

    @Test
    public void petStoreExclusiveParameterWithAlias() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-exclusive-parameter-with-alias.xml:8]: Element <config>, the following parameters cannot be set at the same time: [cash, debt].");
        this.loadConfiguration("validation/petstore-exclusive-parameter-with-alias.xml");
    }

    @Test
    public void petStoreExclusiveGroupInsidePojoOneRequired() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-exclusive-group-inside-pojo-one-required-config.xml:13]: Element <Aquarium> requires that one of its optional parameters must be set, but all of them are missing. One of the following must be set: [frogName, fishName].");
        this.loadConfiguration("validation/petstore-exclusive-group-inside-pojo-one-required-config.xml");
    }

    @Test
    public void petStoreExclusiveParameterRequired() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("[validation/petstore-exclusive-required-parameter.xml:9]: Element <Breeder> requires that one of its optional parameters must be set, but all of them are missing. One of the following must be set: [mammals, birds].");
        this.loadConfiguration("validation/petstore-exclusive-required-parameter.xml");
    }

    @Test
    public void configLevelOperationNegative() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage("Root component 'appleEatsBanana' defines an usage of operation 'eatBanana' which points to configuration 'apple'. The selected config does not support that operation.");
        this.loadConfiguration("validation/vegan-invalid-config-for-operations.xml");
    }

    @Test
    public void configLevelSourceNegative() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage("Root component 'harvest-apples' defines an usage of operation 'harvest-apples' which points to configuration 'banana'. The selected config does not support that operation.");
        this.loadConfiguration("validation/vegan-invalid-config-for-sources.xml");
    }

    @Test
    public void routerStereotypeValidation() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Invalid content was found starting with element");
        this.expectedException.expectMessage("set-variable");
        this.loadConfiguration("scopes/heisenberg-stereotype-validation-config.xml");
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel petStore = this.loadExtension(PetStoreConnector.class, Collections.emptySet());
        ExtensionModel heisenberg = this.loadExtension(HeisenbergExtension.class, Collections.emptySet());
        ExtensionModel vegan = this.loadExtension(VeganExtension.class, Collections.emptySet());
        ArrayList<ExtensionModel> extensions = new ArrayList<ExtensionModel>();
        extensions.addAll(super.getRequiredExtensions());
        extensions.add(petStore);
        extensions.add(heisenberg);
        extensions.add(vegan);
        return extensions;
    }
}

