/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import io.qameta.allure.Issue;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.test.module.extension.streaming.AbstractStreamingExtensionTestCase;

@Issue(value="W-11073049")
public class PrintableStreamingOperationParameterTestCase
extends AbstractStreamingExtensionTestCase {
    private static final String STREAM_CONTENT = "This is the stream content.";

    protected String getConfigFile() {
        return "streaming/streaming-parameter-config.xml";
    }

    @Test
    public void printableCursorStream() throws Exception {
        String result = (String)((FlowRunner)this.flowRunner("streamingParameter").withPayload((Object)new ByteBasedCursorStream(STREAM_CONTENT.getBytes()))).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)STREAM_CONTENT));
    }

    private static class ByteBasedCursorStream
    extends CursorStream {
        private byte[] content;
        private int position;

        public ByteBasedCursorStream(byte[] content) {
            this.content = content;
            this.position = 0;
        }

        public int read() throws IOException {
            if (this.position >= this.content.length) {
                return 0;
            }
            return this.content[this.position++];
        }

        public long getPosition() {
            return this.position;
        }

        public void seek(long position) throws IOException {
            this.position = (int)position;
        }

        public void release() {
        }

        public boolean isReleased() {
            return false;
        }

        public CursorProvider getProvider() {
            return null;
        }

        public String toString() {
            return new String(this.content);
        }
    }
}

