/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.reconnection;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.test.extension.reconnection.FallibleReconnectableSource;
import org.mule.extension.test.extension.reconnection.NonReconnectableSource;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.extension.test.extension.reconnection.ReconnectionOperations;
import org.mule.extension.test.extension.reconnection.SynchronizableConnection;
import org.mule.extension.test.extension.reconnection.SynchronizableSource;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ReconnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final long TIMEOUT = 5000L;
    private static final long POLL_DELAY = 500L;
    private static List<CoreEvent> capturedEvents;

    public static void resetCounters() {
        ReconnectionOperations.closePagingProviderCalls = 0;
        ReconnectionOperations.getPageCalls = 0;
        ReconnectableConnectionProvider.disconnectCalls = 0;
        SynchronizableSource.first = true;
        SynchronizableConnection.disconnectionWaitedFullTimeout = false;
    }

    protected String getConfigFile() {
        return "reconnection-config.xml";
    }

    protected void doSetUp() throws Exception {
        capturedEvents = new LinkedList<CoreEvent>();
        ReconnectableConnectionProvider.fail = false;
        FallibleReconnectableSource.fail = false;
        NonReconnectableSource.fail = false;
    }

    protected void doTearDown() throws Exception {
        capturedEvents = null;
        ReconnectableConnectionProvider.fail = false;
        FallibleReconnectableSource.fail = false;
        NonReconnectableSource.fail = false;
    }

    @Test
    public void reconnectSource() throws Exception {
        ((Startable)this.getFlowConstruct("reconnectForever")).start();
        PollingProber.check((long)5000L, (long)1000L, () -> !capturedEvents.isEmpty());
        this.switchConnection();
        PollingProber.check((long)10000L, (long)1000L, () -> {
            List<CoreEvent> list = capturedEvents;
            synchronized (list) {
                return capturedEvents.stream().map(event -> (ReconnectableConnection)event.getMessage().getPayload().getValue()).filter(c -> c.getReconnectionAttempts() >= 3).findAny().isPresent();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendNotificationOnReconnection() throws Exception {
        Latch latch = new Latch();
        ArrayList notifications = new ArrayList();
        ExceptionNotificationListener listener = notification -> {
            notifications.add(notification);
            latch.release();
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)listener);
        try {
            this.reconnectSource();
            latch.await(5000L, TimeUnit.MILLISECONDS);
            Assert.assertThat((Object)notifications.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Assert.assertThat((Object)((ExceptionNotification)notifications.get(0)).getInfo(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)((ExceptionNotification)notifications.get(0)).getInfo().getException(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)((ExceptionNotification)notifications.get(0)).getInfo().getException(), (Matcher)Matchers.instanceOf(ConnectionException.class));
        }
        finally {
            this.notificationListenerRegistry.unregisterListener((NotificationListener)listener);
        }
    }

    @Test
    public void noReconnectSource() throws Exception {
        ((Startable)this.getFlowConstruct("noReconnect")).start();
        PollingProber.check((long)5000L, (long)500L, () -> !capturedEvents.isEmpty());
        NonReconnectableSource.fail = true;
        PollingProber.check((long)5000L, (long)500L, () -> NonReconnectableSource.attempts.get() > 0);
        this.clear(capturedEvents);
        PollingProber.checkNot((long)5000L, (long)500L, () -> this.size(capturedEvents) > 0);
    }

    @Test
    public void doNotStartSourceTwiceAfterExceptionOnReconnection() throws Exception {
        ((Startable)this.getFlowConstruct("reconnectAfterFailure")).start();
        PollingProber.check((long)5000L, (long)500L, () -> !capturedEvents.isEmpty());
        FallibleReconnectableSource.fail = true;
        PollingProber.checkNot((long)5000L, (long)500L, () -> FallibleReconnectableSource.simultaneouslyStartedSources);
        FallibleReconnectableSource.release();
        PollingProber.checkNot((long)5000L, (long)500L, () -> FallibleReconnectableSource.simultaneouslyStartedSources);
    }

    @Test
    public void getInlineRetryPolicyTemplate() throws Exception {
        RetryPolicyTemplate template = (RetryPolicyTemplate)this.flowRunner("getInlineReconnection").run().getMessage().getPayload().getValue();
        this.assertRetryTemplate(template, true, 30, 50L);
    }

    @Test
    public void getInlineRetryPolicyBlockingTemplate() throws Exception {
        RetryPolicyTemplate template = (RetryPolicyTemplate)this.flowRunner("getInlineReconnectionBlocking").run().getMessage().getPayload().getValue();
        this.assertRetryTemplate(template, false, 30, 50L);
    }

    @Test
    public void reconnectAfterConnectionExceptionOnFirstPage() throws Exception {
        ReconnectionTestCase.resetCounters();
        CursorIterator iterator = this.getCursor("pagedOperation", 1, MuleErrors.CONNECTIVITY);
        iterator.next();
        Assert.assertThat((String)"Connection was not disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Paging provider was not closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotReconnectAfterOtherExceptionOnFirstPage() throws Throwable {
        ReconnectionTestCase.resetCounters();
        try {
            CursorIterator iterator = this.getCursor("pagedOperation", 1, MuleErrors.VALIDATION);
            iterator.next();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"An illegal argument was received."));
            Assert.assertThat((String)"Paging provider was not closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((String)"Connection was disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)0));
            throw e.getCause();
        }
    }

    @Test
    public void reconnectionDuringConnectionExceptionOnSecondPage() throws Exception {
        ReconnectionTestCase.resetCounters();
        CursorIterator iterator = this.getCursor("pagedOperation", 2, MuleErrors.CONNECTIVITY);
        iterator.next();
        Assert.assertThat((String)"Connection was disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((String)"Paging provider was closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)0));
        iterator.next();
        Assert.assertThat((String)"Connection was not disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Paging provider was closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotReconnectAfterOtherExceptionOnSecondPage() throws Exception {
        ReconnectionTestCase.resetCounters();
        try {
            CursorIterator iterator = this.getCursor("pagedOperation", 2, MuleErrors.VALIDATION);
            iterator.next();
            iterator.next();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"An illegal argument was received."));
            Assert.assertThat((String)"Paging provider was not closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((String)"Connection was disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)0));
            throw e;
        }
    }

    @Test
    public void stickyConnectionIsClosedAndReconnectedDuringConnectionExceptionOnFirstPage() throws Exception {
        ReconnectionTestCase.resetCounters();
        CursorIterator iterator = this.getCursor("stickyPagedOperation", 1, MuleErrors.CONNECTIVITY);
        iterator.next();
        Assert.assertThat((String)"Connection was not disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Paging provider was not closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test(expected=ModuleException.class)
    public void stickyConnectionIsNotReconnectedDuringConnectionExceptionOnSecondPage() throws Exception {
        ReconnectionTestCase.resetCounters();
        try {
            CursorIterator iterator = this.getCursor("stickyPagedOperation", 2, MuleErrors.CONNECTIVITY);
            iterator.next();
            iterator.next();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ModuleException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ConnectionException.class));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.is((Object)"Failed to retrieve Page"));
            Assert.assertThat((String)"Paging provider was not closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((String)"Connection was not disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)1));
            throw e;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void stickyConnectionIsNotReconnectedDuringOtherExceptionOnSecondPage() throws Exception {
        ReconnectionTestCase.resetCounters();
        try {
            CursorIterator iterator = this.getCursor("stickyPagedOperation", 2, MuleErrors.VALIDATION);
            iterator.next();
            iterator.next();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"An illegal argument was received."));
            Assert.assertThat((String)"Paging provider was not closed.", (Object)ReconnectionOperations.closePagingProviderCalls, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((String)"Connection was not disconnected.", (Object)ReconnectableConnectionProvider.disconnectCalls, (Matcher)CoreMatchers.is((Object)0));
            throw e;
        }
    }

    @Test
    public void connectionInvalidatedOnCallback() throws Exception {
        ReconnectionTestCase.resetCounters();
        ((Startable)this.getFlowConstruct("synchronizableSource")).start();
        PollingProber.check((long)5000L, (long)500L, () -> SynchronizableConnection.disconnectionWaitedFullTimeout);
    }

    @Test
    public void connectionInvalidatedAndRecreatedIfConnectionExceptionOnStart() throws Exception {
        ((Startable)this.getFlowConstruct("invalidateConnectionIfConnectionExceptionOnStart")).start();
        PollingProber.check((long)10000L, (long)1000L, () -> {
            List<CoreEvent> list = capturedEvents;
            synchronized (list) {
                return capturedEvents.stream().flatMap(event -> ((List)event.getMessage().getPayload().getValue()).stream()).distinct().count() == 5L;
            }
        });
    }

    protected void assertRetryTemplate(RetryPolicyTemplate template, boolean async, int count, long freq) throws Exception {
        Assert.assertThat((Object)template.isAsync(), (Matcher)CoreMatchers.is((Object)async));
        RetryPolicy policy = template.createRetryInstance();
        Assert.assertThat((Object)ClassUtils.getFieldValue((Object)policy, (String)"count", (boolean)false), (Matcher)CoreMatchers.is((Object)count));
        Duration duration = (Duration)ClassUtils.getFieldValue((Object)policy, (String)"frequency", (boolean)false);
        Assert.assertThat((Object)duration.toMillis(), (Matcher)CoreMatchers.is((Object)freq));
    }

    private void switchConnection() throws Exception {
        this.flowRunner("switchConnection").run();
    }

    private <T> CursorIterator<T> getCursor(String flowName, Integer failOn, MuleErrors errorType) throws Exception {
        CursorIteratorProvider provider = (CursorIteratorProvider)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)failOn)).withVariable("errorType", (Object)errorType)).keepStreamsOpen().run().getMessage().getPayload().getValue();
        return (CursorIterator)provider.openCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(List<CoreEvent> list) {
        List<CoreEvent> list2 = list;
        synchronized (list2) {
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(List<CoreEvent> list) {
        List<CoreEvent> list2 = list;
        synchronized (list2) {
            return list.size();
        }
    }

    public static class CaptureProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = capturedEvents;
            synchronized (list) {
                capturedEvents.add(event);
            }
            return event;
        }
    }
}

