/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.value;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ParameterWhitespaceTrimmingTestCase
extends AbstractExtensionFunctionalTestCase {
    private final boolean disableWhitespaceTrimming;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"disable whitespace trimming", true}, {"enable whitespace trimming (default behaviour)", false});
    }

    public ParameterWhitespaceTrimmingTestCase(String name, boolean disableWhitespaceTrimming) {
        this.disableWhitespaceTrimming = disableWhitespaceTrimming;
        if (disableWhitespaceTrimming) {
            System.setProperty("mule.disable.attribute.parameter.whitespace.trimming", "true");
        } else {
            System.clearProperty("mule.disable.attribute.parameter.whitespace.trimming");
        }
    }

    protected String getConfigFile() {
        return "values/some-parameter-group-config.xml";
    }

    @Test
    public void whitespacesForSimpleParameter() throws Exception {
        Object value = this.flowRunner("value").run().getMessage().getPayload().getValue();
        if (this.disableWhitespaceTrimming) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
        } else {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
        }
    }

    @Test
    public void whitespacesAreNotTrimmedForSimpleParameterExpression() throws Exception {
        Object value = this.flowRunner("expression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreTrimmedForContent() throws Exception {
        Object value = this.flowRunner("content").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
    }

    @Test
    public void whitespacesAreNotTrimmedForContentExpression() throws Exception {
        Object value = this.flowRunner("contentExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreNotTrimmedForContentCDATA() throws Exception {
        Object value = this.flowRunner("contentCDATA").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreTrimmedForText() throws Exception {
        Object value = this.flowRunner("text").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
    }

    @Test
    public void whitespacesAreNotTrimmedForTextExpression() throws Exception {
        Object value = this.flowRunner("textExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreNotTrimmedForTextCDATA() throws Exception {
        Object value = this.flowRunner("textCDATA").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesForPojo() throws Exception {
        Object value = this.flowRunner("pojo").run().getMessage().getPayload().getValue();
        if (this.disableWhitespaceTrimming) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
        } else {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
        }
    }

    @Test
    public void whitespacesAreNotTrimmedForPojoExpression() throws Exception {
        Object value = this.flowRunner("pojoExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreTrimmedForPojoText() throws Exception {
        Object value = this.flowRunner("pojoText").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
    }

    @Test
    public void whitespacesAreNotTrimmedForPojoTextExpression() throws Exception {
        Object value = this.flowRunner("pojoTextExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreTrimmedForPojoTextCDATA() throws Exception {
        Object value = this.flowRunner("pojoTextCDATA").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
    }

    @Test
    public void whitespacesForPg() throws Exception {
        Object value = this.flowRunner("pg").run().getMessage().getPayload().getValue();
        if (this.disableWhitespaceTrimming) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
        } else {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
        }
    }

    @Test
    public void whitespacesAreNotTrimmedForPgExpression() throws Exception {
        Object value = this.flowRunner("pgExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreTrimmedForPgText() throws Exception {
        Object value = this.flowRunner("pgText").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
    }

    @Test
    public void whitespacesAreNotTrimmedForPgTextExpression() throws Exception {
        Object value = this.flowRunner("pgTextExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreNotTrimmedForPgTextCDATA() throws Exception {
        Object value = this.flowRunner("pgTextCDATA").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesForPgDsl() throws Exception {
        Object value = this.flowRunner("pgDsl").run().getMessage().getPayload().getValue();
        if (this.disableWhitespaceTrimming) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
        } else {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
        }
    }

    @Test
    public void whitespacesAreNotTrimmedForPgDSLExpression() throws Exception {
        Object value = this.flowRunner("pgDslExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreTrimmedForPgDslText() throws Exception {
        Object value = this.flowRunner("pgDslText").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
    }

    @Test
    public void whitespacesAreNotTrimmedForPgDslTextExpression() throws Exception {
        Object value = this.flowRunner("pgDslTextExpression").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }

    @Test
    public void whitespacesAreNotTrimmedForPgDslTextCDATA() throws Exception {
        Object value = this.flowRunner("pgDslTextCDATA").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
    }
}

