/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.config.ConfiguredComponent;
import org.mule.runtime.extension.api.runtime.source.ParameterizedSource;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.matcher.IsEmptyOptional;
import org.mule.tck.probe.PollingProber;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Ignore(value="MULE-18067")
public class HeisenbergMessageSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int TIMEOUT_MILLIS = 50000;
    public static final int POLL_DELAY_MILLIS = 100;
    public static final int TIME_WAIT_MILLIS = 3000;
    private static final String OUT = "out";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Flow flow;

    protected String getConfigFile() {
        return "heisenberg-source-config.xml";
    }

    protected void doSetUp() throws Exception {
        HeisenbergExtension.sourceTimesStarted = 0;
        HeisenbergSource.resetHeisenbergSource();
        super.doSetUp();
    }

    protected void doTearDown() throws Exception {
        if (this.flow != null) {
            this.flow.stop();
        }
        super.doTearDown();
        HeisenbergSource.resetHeisenbergSource();
    }

    @Test
    public void source() throws Exception {
        this.startFlow("source");
        this.assertSourceCompleted();
    }

    @Test
    public void sourceRestartedWithDynamicConfig() throws Exception {
        Long gatheredMoney = HeisenbergSource.gatheredMoney;
        this.startFlow("source");
        PollingProber.check((long)50000L, (long)100L, () -> {
            Assert.assertThat((Object)HeisenbergSource.gatheredMoney, (Matcher)Matchers.greaterThan((Comparable)gatheredMoney));
            return true;
        });
        this.stopFlow("source");
        Long gatheredMoneyAfterStop = HeisenbergSource.gatheredMoney;
        PollingProber.checkNot((long)3000L, (long)100L, () -> {
            Assert.assertThat((Object)HeisenbergSource.gatheredMoney, (Matcher)Matchers.greaterThan((Comparable)gatheredMoneyAfterStop));
            return true;
        });
        this.startFlow("source");
        PollingProber.check((long)50000L, (long)100L, () -> {
            Assert.assertThat((Object)HeisenbergSource.gatheredMoney, (Matcher)Matchers.greaterThan((Comparable)gatheredMoneyAfterStop));
            return true;
        });
    }

    protected void assertSourceCompleted() {
        PollingProber.probe((long)50000L, (long)100L, () -> HeisenbergSource.gatheredMoney > 100L && HeisenbergSource.receivedGroupOnSource && HeisenbergSource.receivedInlineOnSuccess);
    }

    @Test
    public void onException() throws Exception {
        this.startFlow("sourceFailed");
        this.assertSourceFailed();
    }

    protected void assertSourceFailed() {
        PollingProber.probe((long)50000L, (long)100L, () -> HeisenbergSource.gatheredMoney == -1L && HeisenbergSource.receivedGroupOnSource && HeisenbergSource.receivedInlineOnError);
    }

    @Test
    public void enrichExceptionOnStart() throws Exception {
        this.expectedException.expectMessage("Enriched Connection Exception: corePoolSize cannot be a negative value");
        this.startFlow("sourceFailedOnStart");
    }

    @Test
    public void reconnectWithEnrichedException() throws Exception {
        this.startFlow("sourceFailedOnRuntime");
        PollingProber.probe((long)50000L, (long)100L, () -> HeisenbergExtension.sourceTimesStarted > 2);
    }

    @Test
    public void sourceOnSuccessCallsOnTerminate() throws Exception {
        this.startFlow("source");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(true, false, true));
        Assert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.SUCCESS));
        Assert.assertThat((Object)HeisenbergSource.error, (Matcher)IsEmptyOptional.empty());
    }

    @Test
    public void sourceFailsOnSuccessParametersCallsOnErrorAndOnTerminate() throws Exception {
        this.startFlow("sourceWithInvalidSuccessParameter");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
        Assert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_INVOKE));
        Assert.assertThat((Object)HeisenbergSource.error, (Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty()));
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read(OUT, 5000L).getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"Expected.")));
    }

    @Test
    public void sourceFailsOnSuccessBodyCallsOnErrorAndOnTerminate() throws Exception {
        this.startFlow("sourceFailsOnSuccessBodyCallsOnErrorAndOnTerminate");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(true, true, true));
        Assert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_BODY));
        Assert.assertThat((Object)HeisenbergSource.error, (Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty()));
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read(OUT, 5000L).getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"Expected.")));
    }

    @Test
    public void sourceFailsOnSuccessAndOnErrorParametersCallsOnTerminate() throws Exception {
        this.startFlow("sourceWithInvalidSuccessAndErrorParameters");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, false, true));
        Assert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_INVOKE));
        Optional optionalError = HeisenbergSource.error;
        Assert.assertThat((Object)optionalError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty())));
        Assert.assertThat((Object)((Error)optionalError.get()).getErrorType(), (Matcher)CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE)));
        MuleException me = (MuleException)Exceptions.unwrap((Throwable)((Error)optionalError.get()).getCause());
        Assert.assertThat((Object)((String)me.getInfo().get("Element")), (Matcher)Matchers.containsString((String)"sourceWithInvalidSuccessAndErrorParameters/source"));
        Assert.assertThat((Object)((String)me.getInfo().get("Element DSL")), (Matcher)Matchers.containsString((String)"heisenberg:success-info"));
    }

    @Test
    public void sourceFailsInsideOnErrorAndCallsOnTerminate() throws Exception {
        this.startFlow("sourceFailsInsideOnError");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
        Assert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_BODY));
        Optional optionalError = HeisenbergSource.error;
        Assert.assertThat((Object)optionalError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty())));
        Assert.assertThat((Object)((Error)optionalError.get()).getErrorType(), (Matcher)CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND)));
    }

    @Test
    public void failureInFlowCallsOnErrorDirectlyAndHandlesItCorrectly() throws Exception {
        this.startFlow("failureInFlowCallsOnErrorDirectly");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
    }

    @Test
    public void failureInFlowErrorHandlerCallsOnErrorDirectlyAndHandlesItCorrectly() throws Exception {
        this.startFlow("failureInFlowErrorHandlerCallsOnErrorDirectly");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, true, true));
    }

    @Test
    public void failureInFlowCallsOnErrorDirectlyAndFailsHandlingIt() throws Exception {
        this.startFlow("failureInFlowCallsOnErrorDirectlyAndFailsHandlingIt");
        PollingProber.probe((long)50000L, (long)100L, () -> this.assertState(false, false, true));
        Assert.assertThat((Object)HeisenbergSource.terminateStatus, (Matcher)CoreMatchers.is((Object)HeisenbergSource.TerminateStatus.ERROR_INVOKE));
        Optional optionalError = HeisenbergSource.error;
        Assert.assertThat((Object)optionalError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyOptional.empty())));
        Assert.assertThat((Object)((Error)optionalError.get()).getErrorType(), (Matcher)CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE)));
        MuleException me = (MuleException)Exceptions.unwrap((Throwable)((Error)optionalError.get()).getCause());
        Assert.assertThat((Object)((String)me.getInfo().get("Element")), (Matcher)Matchers.containsString((String)"failureInFlowCallsOnErrorDirectlyAndFailsHandlingIt/source"));
        Assert.assertThat((Object)((String)me.getInfo().get("Element DSL")), (Matcher)Matchers.containsString((String)"heisenberg:success-info"));
    }

    @Test
    public void obtainSourceParameters() {
        Component element = (Component)this.locator.find(Location.builder().globalName("source").addSourcePart().build()).get();
        Assert.assertThat((Object)element, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ParameterizedSource.class)));
        ParameterizedSource source = (ParameterizedSource)element;
        Map parameters = source.getInitialisationParameters();
        Assert.assertThat(parameters.get("initialBatchNumber"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat(parameters.get("corePoolSize"), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void obtainSourceConfigParameters() {
        Component element = (Component)this.locator.find(Location.builder().globalName("source").addSourcePart().build()).get();
        Assert.assertThat((Object)element, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConfiguredComponent.class)));
        ConfiguredComponent source = (ConfiguredComponent)element;
        ConfigurationState configurationState = ((ConfigurationInstance)source.getConfigurationInstance().get()).getState();
        Map configParameters = configurationState.getConfigParameters();
        Assert.assertThat((Object)configParameters.size(), (Matcher)CoreMatchers.is((Object)13));
        this.assertParameter(configParameters, "monthlyIncomes", Matchers.hasSize((int)2));
        this.assertParameter(configParameters, "cancer", CoreMatchers.is((Object)true));
        this.assertParameter(configParameters, "money", CoreMatchers.equalTo((Object)new BigDecimal("0")));
        this.assertParameter(configParameters, "initialHealth", CoreMatchers.is((Object)HealthStatus.CANCER));
        this.assertParameter(configParameters, "endingHealth", CoreMatchers.is((Object)HealthStatus.CANCER));
        this.assertParameter(configParameters, "name", CoreMatchers.is((Object)"Heisenberg"));
        this.assertParameter(configParameters, "age", CoreMatchers.is((Object)50));
        this.assertParameter(configParameters, "brotherInLaw", CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Map connectionParameters = configurationState.getConnectionParameters();
        Assert.assertThat((Object)connectionParameters.size(), (Matcher)CoreMatchers.is((Object)2));
        this.assertParameter(connectionParameters, "saulPhoneNumber", CoreMatchers.equalTo((Object)"505-503-4455"));
    }

    @Test
    public void componentLocationInjected() throws Exception {
        this.startFlow("source");
        Assert.assertThat((Object)HeisenbergSource.location, (Matcher)CoreMatchers.is((Object)"source/source"));
    }

    @Test
    public void configNameInjected() throws Exception {
        this.startFlow("source");
        Assert.assertThat((Object)HeisenbergSource.configName, (Matcher)CoreMatchers.is((Object)"heisenberg"));
    }

    private void assertParameter(Map<String, Object> parameters, String propertyName, Matcher matcher) {
        Assert.assertThat((Object)parameters.get(propertyName), (Matcher)matcher);
    }

    protected void startFlow(String flowName) throws Exception {
        this.flow = (Flow)this.getFlowConstruct(flowName);
        this.flow.start();
    }

    protected void stopFlow(String flowName) throws Exception {
        this.flow = (Flow)this.getFlowConstruct(flowName);
        this.flow.stop();
    }

    private boolean assertState(boolean executedOnSuccess, boolean executedOnError, boolean executedOnTerminate) {
        Assert.assertThat((String)"OnSuccess", (Object)HeisenbergSource.executedOnSuccess, (Matcher)CoreMatchers.is((Object)executedOnSuccess));
        Assert.assertThat((String)"OnError", (Object)HeisenbergSource.executedOnError, (Matcher)CoreMatchers.is((Object)executedOnError));
        Assert.assertThat((String)"OnTerminate", (Object)HeisenbergSource.executedOnTerminate, (Matcher)CoreMatchers.is((Object)executedOnTerminate));
        return true;
    }
}

