/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.notification;

import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.ExtensionNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.heisenberg.extension.model.SimpleKnockeableDoor;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ExtensionNotificationsTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String HEISENBERG = "Heisenberg".toUpperCase();
    private static final String NEW_BATCH = "NEW_BATCH";
    private static final String NEXT_BATCH = "NEXT_BATCH";
    private static final String BATCH_TERMINATED = "BATCH_TERMINATED";
    private static final String BATCH_DELIVERY_FAILED = "BATCH_DELIVERY_FAILED";
    private static final String BATCH_DELIVERED = "BATCH_DELIVERED";
    private static final String BATCH_FAILED = "BATCH_FAILED";
    private static final String KNOCKING_DOOR = "KNOCKING_DOOR";
    private static final String KNOCKED_DOOR = "KNOCKED_DOOR";
    private TestExtensionNotificationListener listener = null;
    @Inject
    private NotificationListenerRegistry notificationListenerRegistry;

    protected String getConfigFile() {
        return "notifications-config.xml";
    }

    @Test
    public void operationFiresNotificationsWithCustomData() throws Exception {
        Latch latch = new Latch();
        this.setUpListener(notification -> this.checkIfDone(latch, 2), false);
        String correlationId = this.flowRunner("operationNotification").run().getCorrelationId();
        Assert.assertThat((String)"Expected notifications not received.", (Object)latch.await(6000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)KNOCKING_DOOR));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)KNOCKED_DOOR));
        ExtensionNotification knockingDoor = (ExtensionNotification)notifications.get((Object)KNOCKING_DOOR);
        Assert.assertThat((Object)knockingDoor, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)knockingDoor.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)knockingDoor.getData().getValue(), (Matcher)Matchers.instanceOf(SimpleKnockeableDoor.class));
        Assert.assertThat((Object)((SimpleKnockeableDoor)knockingDoor.getData().getValue()).getSimpleName(), (Matcher)Matchers.is((Object)"Top Level Skyler @ 308 Negra Arroyo Lane"));
        Assert.assertThat((Object)knockingDoor.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification knockedDoor = (ExtensionNotification)notifications.get((Object)KNOCKED_DOOR);
        Assert.assertThat((Object)knockedDoor, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)knockedDoor.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)knockedDoor.getData().getValue(), (Matcher)Matchers.instanceOf(SimpleKnockeableDoor.class));
        Assert.assertThat((Object)((SimpleKnockeableDoor)knockedDoor.getData().getValue()).getSimpleName(), (Matcher)Matchers.is((Object)"Top Level Skyler @ 308 Negra Arroyo Lane"));
        Assert.assertThat((Object)knockedDoor.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    public void sourceFiresNotificationsOnSuccess() throws Exception {
        Latch latch = new Latch();
        this.setUpListener(notification -> this.checkIfDone(latch, 4), false);
        Flow flow = (Flow)this.getFlowConstruct("sourceNotifications");
        flow.start();
        Assert.assertThat((String)"Expected notifications not received.", (Object)latch.await(6000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        Assert.assertThat(keys, (Matcher)Matchers.hasItem((Object)NEW_BATCH));
        Assert.assertThat(keys, (Matcher)Matchers.hasItem((Object)NEXT_BATCH));
        Assert.assertThat(keys, (Matcher)Matchers.hasItem((Object)BATCH_DELIVERED));
        Assert.assertThat(keys, (Matcher)Matchers.hasItem((Object)BATCH_TERMINATED));
        ExtensionNotification newBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(NEW_BATCH), 1);
        String correlationId = newBatch.getEvent().getCorrelationId();
        ExtensionNotification nextBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(NEXT_BATCH), 1000000L);
        Assert.assertThat((Object)nextBatch.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchRedelivered = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(BATCH_DELIVERED), 100L);
        Assert.assertThat((Object)batchRedelivered.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchTerminated = this.verifyNotificationAndValue((ExtensionNotification)notifications.get(BATCH_TERMINATED), 1);
        Assert.assertThat((Object)batchTerminated.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    public void sourceFiresNotificationsOnError() throws Exception {
        Latch latch = new Latch();
        this.setUpListener(notification -> this.checkIfDone(latch, 4), false);
        Flow flow = (Flow)this.getFlowConstruct("sourceNotificationsError");
        flow.start();
        Assert.assertThat((String)"Expected notifications not received", (Object)latch.await(6000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEW_BATCH));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEXT_BATCH));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_DELIVERY_FAILED));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_TERMINATED));
        ExtensionNotification newBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get((Object)NEW_BATCH), 1);
        String correlationId = newBatch.getEvent().getCorrelationId();
        ExtensionNotification nextBatch = this.verifyNotificationAndValue((ExtensionNotification)notifications.get((Object)NEXT_BATCH), 1000000L);
        Assert.assertThat((Object)nextBatch.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchDeliveryFailed = (ExtensionNotification)notifications.get((Object)BATCH_DELIVERY_FAILED);
        Assert.assertThat((Object)batchDeliveryFailed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)batchDeliveryFailed.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)batchDeliveryFailed.getData().getValue(), (Matcher)Matchers.instanceOf(PersonalInfo.class));
        Assert.assertThat((Object)((PersonalInfo)batchDeliveryFailed.getData().getValue()).getAge(), (Matcher)Matchers.is((Object)27));
        Assert.assertThat((Object)batchDeliveryFailed.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
        ExtensionNotification batchTerminated = this.verifyNotificationAndValue((ExtensionNotification)notifications.get((Object)BATCH_TERMINATED), 1);
        Assert.assertThat((Object)batchTerminated.getEvent().getCorrelationId(), (Matcher)Matchers.is((Object)correlationId));
    }

    @Test
    @Story(value="Backpressure")
    public void sourceFiresNotificationsOnBackPressure() throws Exception {
        Latch failed = new Latch();
        Reference batchFailed = new Reference();
        this.setUpListener(notification -> {
            if (BATCH_FAILED.equals(notification.getAction().getIdentifier())) {
                batchFailed.set(notification);
                failed.release();
            }
        }, true);
        Flow flow = (Flow)this.getFlowConstruct("sourceNotificationsBackPressure");
        flow.start();
        Assert.assertThat((String)"Batch failure notification not received.", (Object)failed.await(10000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        ExtensionNotification backPressureNotification = (ExtensionNotification)batchFailed.get();
        Assert.assertThat((Object)backPressureNotification, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        final String correlationId = backPressureNotification.getEvent().getCorrelationId();
        new PollingProber(10000L, 200L).check(new Probe(){

            public boolean isSatisfied() {
                return ExtensionNotificationsTestCase.this.listener.getNotifications().getAll((Object)ExtensionNotificationsTestCase.BATCH_FAILED).stream().anyMatch(n -> n.getEvent().getCorrelationId().equals(correlationId));
            }

            public String describeFailure() {
                return "Expected notifications not found.";
            }
        });
        flow.stop();
        MultiMap<String, ExtensionNotification> notifications = this.listener.getNotifications();
        Set keys = notifications.keySet();
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEW_BATCH));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)NEXT_BATCH));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_FAILED));
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem((Object)BATCH_TERMINATED));
        int batchNumber = (Integer)backPressureNotification.getData().getValue();
        this.verifyNotificationAndValue(backPressureNotification, batchNumber);
        this.verifyNotificationAndValue(this.getNotificationMatch(notifications, correlationId, BATCH_TERMINATED), batchNumber);
    }

    private void checkIfDone(Latch latch, int expectedKeys) {
        if (this.listener.getNotifications().keySet().size() == expectedKeys) {
            latch.release();
        }
    }

    private ExtensionNotification getNotificationMatch(MultiMap<String, ExtensionNotification> notifications, String correlation, String id) {
        return notifications.getAll((Object)id).stream().filter(n -> correlation.equals(n.getEvent().getCorrelationId())).findAny().orElse(null);
    }

    private <T> ExtensionNotification verifyNotificationAndValue(ExtensionNotification notification, T expected) {
        Assert.assertThat((Object)notification.getAction().getNamespace(), (Matcher)Matchers.is((Object)HEISENBERG));
        Assert.assertThat((Object)notification.getData().getValue(), (Matcher)Matchers.instanceOf(expected.getClass()));
        Assert.assertThat((Object)notification.getData().getValue(), (Matcher)Matchers.is(expected));
        return notification;
    }

    private void setUpListener(Consumer<ExtensionNotification> onNotification, boolean correlationOn) {
        this.listener = new TestExtensionNotificationListener(onNotification, correlationOn);
        this.notificationListenerRegistry.registerListener((NotificationListener)this.listener);
    }

    private class TestExtensionNotificationListener
    implements ExtensionNotificationListener {
        private final Consumer<ExtensionNotification> onNotification;
        private final MultiMap<String, ExtensionNotification> notifications = new MultiMap();
        private Map<String, Integer> correlationCount;

        public TestExtensionNotificationListener(Consumer<ExtensionNotification> onNotification, boolean correlationOn) {
            this.onNotification = onNotification;
            if (correlationOn) {
                this.correlationCount = new HashMap<String, Integer>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotification(ExtensionNotification notification) {
            Object object = this.notifications;
            synchronized (object) {
                this.notifications.put((Object)notification.getAction().getIdentifier(), (Object)notification);
            }
            if (this.correlationCount != null) {
                object = this.correlationCount;
                synchronized (object) {
                    String correlationId = notification.getEvent().getCorrelationId();
                    this.correlationCount.put(correlationId, this.correlationCount.computeIfAbsent(correlationId, correlation -> 0) + 1);
                }
            }
            this.onNotification.accept(notification);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiMap<String, ExtensionNotification> getNotifications() {
            MultiMap<String, ExtensionNotification> multiMap = this.notifications;
            synchronized (multiMap) {
                return this.notifications.toImmutableMultiMap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Integer getCorrelationCount(String correlationId) {
            Map<String, Integer> map = this.correlationCount;
            synchronized (map) {
                return this.correlationCount.get(correlationId);
            }
        }
    }
}

