/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.test.module.extension.metadata.AbstractMetadataOperationTestCase;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class MetadataCacheTestCase
extends AbstractMetadataOperationTestCase {
    private static final String OUTPUT_AND_METADATA_KEY_CACHE_ID = "1874947571-1840879217-380895431-1745289126-135479212676912086";
    private static final String OUTPUT_METADATA_WITHOUT_KEY_CACHE_ID = "1874947571-1840879217-1768400440-174528912655077923476912086";
    private static final String CONTENT_AND_OUTPUT_CACHE_ID = "1874947571-1840879217-1768400440-174528912655077923476912086";
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;

    public MetadataCacheTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
    }

    protected String getConfigFile() {
        return "metadata-runtime-tests.xml";
    }

    @Override
    public boolean enableLazyInit() {
        return true;
    }

    @Override
    public boolean disableXmlValidations() {
        return false;
    }

    @Override
    protected boolean isDisposeContextPerClass() {
        return false;
    }

    @Before
    public void setUp() throws Exception {
        try {
            this.getMetadataObjectStore().clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.getMetadataObjectStore().clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void multipleCaches() throws Exception {
        this.setLocation("outputAndMetadataKeyCacheResolver");
        this.metadataService.getMetadataKeys(this.location);
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.setLocation("outputMetadataWithoutKeyId");
        this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        this.setLocation("contentAndOutputWithCacheResolverWithSpecificConfig");
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.setLocation("outputAndMetadataKeyCacheResolver");
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        List actualKeys = this.getMetadataObjectStore().allKeys();
        MatcherAssert.assertThat((Object)actualKeys, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)actualKeys, (Matcher)Matchers.hasItems((Object[])new String[]{OUTPUT_AND_METADATA_KEY_CACHE_ID, "1874947571-1840879217-1768400440-174528912655077923476912086", "1874947571-1840879217-1768400440-174528912655077923476912086"}));
    }

    protected void setLocation(String outputAndMetadataKeyCacheResolver) {
        this.location = Location.builder().globalName(outputAndMetadataKeyCacheResolver).addProcessorsPart().addIndexPart(0).build();
    }

    @Test
    public void elementsAreStoredInCaches() throws Exception {
        this.setLocation("outputAndMetadataKeyCacheResolver");
        this.metadataService.getMetadataKeys(this.location);
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.setLocation("contentAndOutputWithCacheResolverWithSpecificConfig");
        this.getSuccessComponentDynamicMetadata();
        MetadataCache configCache = (MetadataCache)this.getMetadataObjectStore().retrieve(OUTPUT_AND_METADATA_KEY_CACHE_ID);
        MatcherAssert.assertThat(configCache.get((Serializable)((Object)"Age")).get(), (Matcher)Is.is((Object)16));
        MatcherAssert.assertThat(configCache.get((Serializable)((Object)"Name")).get(), (Matcher)Is.is((Object)"Juan"));
        MatcherAssert.assertThat(configCache.get((Serializable)((Object)"Brand")).get(), (Matcher)Is.is((Object)"Nikdidas"));
        MetadataCache alternativeConfigCache = (MetadataCache)this.getMetadataObjectStore().retrieve("1874947571-1840879217-1768400440-174528912655077923476912086");
        MatcherAssert.assertThat(alternativeConfigCache.get((Serializable)((Object)"Brand")).get(), (Matcher)Is.is((Object)"Nikdidas"));
    }

    @Test
    public void disposeCacheForConfig() throws Exception {
        this.setLocation("outputAndMetadataKeyCacheResolver");
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.setLocation("contentAndOutputWithCacheResolverWithSpecificConfig");
        this.getSuccessComponentDynamicMetadata();
        MatcherAssert.assertThat((Object)this.getMetadataObjectStore().allKeys(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.getMetadataObjectStore().retrieve(OUTPUT_AND_METADATA_KEY_CACHE_ID);
        this.getMetadataObjectStore().retrieve("1874947571-1840879217-1768400440-174528912655077923476912086");
        this.metadataService.disposeCache("1874947571-1840879217-1768400440-174528912655077923476912086");
        MatcherAssert.assertThat((Object)this.getMetadataObjectStore().allKeys(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.getMetadataObjectStore().retrieve(OUTPUT_AND_METADATA_KEY_CACHE_ID);
        try {
            this.getMetadataObjectStore().retrieve("1874947571-1840879217-1768400440-174528912655077923476912086");
            Assert.fail();
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
    }

    @Test
    public void disposeCacheForPartialId() throws Exception {
        this.setLocation("outputAndMetadataKeyCacheResolver");
        this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        this.setLocation("contentAndOutputWithCacheResolverWithSpecificConfig");
        this.getSuccessComponentDynamicMetadata();
        MatcherAssert.assertThat((Object)this.getMetadataObjectStore().allKeys(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.getMetadataObjectStore().retrieve(OUTPUT_AND_METADATA_KEY_CACHE_ID);
        this.getMetadataObjectStore().retrieve("1874947571-1840879217-1768400440-174528912655077923476912086");
        this.metadataService.disposeCache("1874947571-1840879217");
        MatcherAssert.assertThat((Object)this.getMetadataObjectStore().allKeys(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        try {
            this.getMetadataObjectStore().retrieve(OUTPUT_AND_METADATA_KEY_CACHE_ID);
            Assert.fail();
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
        try {
            this.getMetadataObjectStore().retrieve("1874947571-1840879217-1768400440-174528912655077923476912086");
            Assert.fail();
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
    }

    private ObjectStore<MetadataCache> getMetadataObjectStore() {
        return this.objectStoreManager.getObjectStore("_mulePersistentMetadataService");
    }
}

