/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetAdoptionSchedulerInParamSource;
import org.mule.test.petstore.extension.PetFailingPollingSource;

@Issue(value="MULE-19757")
public class SourceScheduleInParamTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final int TIMEOUT = 5000;
    private static final int DELAY = 100;
    private static final List<CoreEvent> ADOPTION_EVENTS = new LinkedList<CoreEvent>();

    protected void doTearDown() throws Exception {
        ADOPTION_EVENTS.clear();
    }

    protected String getConfigFile() {
        return "source/source-schedule-in-param-config.xml";
    }

    @Before
    public void resetCounters() throws Exception {
        PetFailingPollingSource.STARTED_POLLS = 0;
        PetFailingPollingSource.POLL_INVOCATIONS.clear();
        PetFailingPollingSource.STARTED_SOURCES.clear();
        PetAdoptionSchedulerInParamSource.STARTED_POLLS = 0;
    }

    @Test
    public void vanillaPoll() throws Exception {
        this.startFlow("vanilla");
        this.assertAllPetsAdopted();
        PollingProber.check((long)5000L, (long)200L, () -> {
            List<CoreEvent> list = ADOPTION_EVENTS;
            synchronized (list) {
                return PetAdoptionSchedulerInParamSource.COMPLETED_POLLS > 1 && PetAdoptionSchedulerInParamSource.ADOPTED_PET_COUNT >= ADOPTION_EVENTS.size();
            }
        });
    }

    @Test
    public void failingPoll() throws Exception {
        this.startFlow("failingPoll");
        PollingProber.check((long)5000L, (long)100L, () -> PetAdoptionSchedulerInParamSource.FAILED_ADOPTION_COUNT >= PetAdoptionSchedulerInParamSource.ALL_PETS.size());
    }

    @Description(value="This test reflects a behavior that we must preserve, when a polling source is stopped and started the scheduler must be stopped and a new one must be started.")
    @Test
    public void whenSourceIsStopAndStartedSchedulerIsReset() throws Exception {
        this.startFlow("longFrequencyPoll");
        this.assertStartedPolls(1);
        this.stopFlow("longFrequencyPoll");
        Thread.sleep(1000L);
        this.startFlow("longFrequencyPoll");
        this.assertStartedPolls(1);
    }

    private void assertStartedPolls(int polls) {
        PollingProber.check((long)5000L, (long)200L, () -> {
            MatcherAssert.assertThat((Object)PetAdoptionSchedulerInParamSource.STARTED_POLLS, (Matcher)Matchers.is((Object)polls));
            return true;
        });
    }

    private void assertAllPetsAdopted() {
        PollingProber.check((long)5000L, (long)200L, () -> {
            List<CoreEvent> list = ADOPTION_EVENTS;
            synchronized (list) {
                return ADOPTION_EVENTS.size() >= PetAdoptionSchedulerInParamSource.ALL_PETS.size() && ADOPTION_EVENTS.stream().map(e -> e.getMessage().getPayload().getValue().toString()).collect(Collectors.toList()).containsAll(PetAdoptionSchedulerInParamSource.ALL_PETS);
            }
        });
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    private void stopFlow(String flowName) throws Exception {
        ((Stoppable)this.getFlowConstruct(flowName)).stop();
    }

    public static class AdoptionProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = ADOPTION_EVENTS;
            synchronized (list) {
                ADOPTION_EVENTS.add(event);
            }
            return event;
        }
    }
}

