/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.tck.junit4.matcher.IsEmptyOptional;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class CorrelationInfoTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "correlation-info-config.xml";
    }

    @Test
    public void defaultCorrelationInfo() throws Exception {
        CoreEvent event = this.flowRunner("correlate").run();
        CorrelationInfo correlationInfo = (CorrelationInfo)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)correlationInfo.getEventId(), (Matcher)CoreMatchers.is((Object)event.getContext().getId()));
        Assert.assertThat((Object)correlationInfo.isOutboundCorrelationEnabled(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)correlationInfo.getCorrelationId(), (Matcher)CoreMatchers.is((Object)correlationInfo.getCorrelationId()));
        Assert.assertThat((Object)correlationInfo.getItemSequenceInfo(), (Matcher)CoreMatchers.is((Matcher)IsEmptyOptional.empty()));
    }

    @Test
    public void customCorrelationId() throws Exception {
        String correlationId = "correlateThis";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("correlate").withSourceCorrelationId("correlateThis")).withItemSequenceInfo(ItemSequenceInfo.of((int)43, (int)100))).run();
        CorrelationInfo correlationInfo = (CorrelationInfo)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)correlationInfo.getEventId(), (Matcher)CoreMatchers.is((Object)event.getContext().getId()));
        Assert.assertThat((Object)correlationInfo.isOutboundCorrelationEnabled(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)correlationInfo.getCorrelationId(), (Matcher)CoreMatchers.is((Object)"correlateThis"));
        Assert.assertThat((Object)((ItemSequenceInfo)correlationInfo.getItemSequenceInfo().get()).getPosition(), (Matcher)CoreMatchers.is((Object)43));
        Assert.assertThat((Object)((ItemSequenceInfo)correlationInfo.getItemSequenceInfo().get()).getSequenceSize().getAsInt(), (Matcher)CoreMatchers.is((Object)100));
    }
}

