/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.some.extension.ComplexParameter;

public class SourceWithParameterGroupExclusiveOptionalsOneRequiredTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final int TIMEOUT = 5000;
    private static final int DELAY = 1000;
    private static final List<CoreEvent> EVENTS = new LinkedList<CoreEvent>();

    protected void doTearDown() throws Exception {
        EVENTS.clear();
    }

    protected String getConfigFile() {
        return "values/some-source-parameter-group.xml";
    }

    @Test
    public void testWithSimpleParameter() throws Exception {
        this.startFlow("someParameter");
        this.assertEventsFired();
        MatcherAssert.assertThat((Object)EVENTS.get(0).getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"hello dog!"));
    }

    @Test
    public void testWithComplexParameter() throws Exception {
        this.startFlow("complexParameter");
        this.assertEventsFired();
        MatcherAssert.assertThat((Object)((ComplexParameter)EVENTS.get(0).getMessage().getPayload().getValue()).getAnotherParameter(), (Matcher)Matchers.is((Object)"hello bird!"));
    }

    @Test
    public void testWithSimpleParameterDslTrue() throws Exception {
        this.startFlow("someParameterDslTrue");
        this.assertEventsFired();
        MatcherAssert.assertThat((Object)EVENTS.get(0).getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"hello dog!"));
    }

    @Test
    public void testWithComplexParameterDslTrue() throws Exception {
        this.startFlow("complexParameterDslTrue");
        this.assertEventsFired();
        MatcherAssert.assertThat((Object)((ComplexParameter)EVENTS.get(0).getMessage().getPayload().getValue()).getAnotherParameter(), (Matcher)Matchers.is((Object)"hello bird!"));
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    private void assertEventsFired() {
        PollingProber.check((long)5000L, (long)1000L, () -> {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                return EVENTS.size() >= 1;
            }
        });
    }

    public static class CaptureProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = EVENTS;
            synchronized (list) {
                EVENTS.add(event);
            }
            return event;
        }
    }
}

