/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class BackPressureConfigTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "heisenberg-backpressure-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.componentLocator = (ConfigurationComponentLocator)this.registry.lookupByType(ConfigurationComponentLocator.class).get();
    }

    @Test
    public void defaultsToFail() {
        this.assertStrategy("defaultToFail", MessageSource.BackPressureStrategy.FAIL);
    }

    @Test
    public void configuredToDrop() {
        this.assertStrategy("configuredToDrop", MessageSource.BackPressureStrategy.DROP);
    }

    @Test
    public void defaultCase() {
        this.assertStrategy("defaultCase", MessageSource.BackPressureStrategy.WAIT);
    }

    private void assertStrategy(String flowName, MessageSource.BackPressureStrategy expected) {
        MessageSource source = (MessageSource)this.componentLocator.find(Location.builderFromStringRepresentation((String)(flowName + "/source")).build()).get();
        Assert.assertThat((Object)source.getBackPressureStrategy(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

