/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ExpressionSupportTestCase
extends AbstractExtensionFunctionalTestCase {
    private final String config;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public ExpressionSupportTestCase(String config) {
        this.config = config;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"heisenberg-invalid-expression-parameter.xml"}, {"heisenberg-fixed-parameter-with-expression.xml"}, {"heisenberg-invalid-expression-parameter-inside-group.xml"});
    }

    protected String[] getConfigFiles() {
        return new String[]{this.config};
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.expectedException.expectCause((Matcher)new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable exception) {
                return exception.getMessage().contains("expressions");
            }

            public void describeTo(Description description) {
                description.appendText("exception cause was expected to have the word expressions");
            }
        });
    }

    @Test
    public void invalidConfig() throws Exception {
        Assert.fail((String)"Configuration should have been invalid");
    }
}

