/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.test.marvel.model.Relic;
import org.mule.test.module.extension.streaming.AbstractStreamingExtensionTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ObjectStreamingRepeatabilityTestCase
extends AbstractStreamingExtensionTestCase {
    @Parameterized.Parameter
    public String testName;
    @Parameterized.Parameter(value=1)
    public String configFile;
    @Parameterized.Parameter(value=2)
    public boolean shouldBeRepeatable;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Repeatable items", "repeatable-iterable-items-config.xml", true}, {"Non repeatable items", "non-repeatable-iterable-items-config.xml", false});
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void withNonRepeatableIterable() throws Exception {
        Relic relic = (Relic)this.flowRunner("firstElementOfNonRepeatableIterable").run().getMessage().getPayload().getValue();
        this.assertValueRepeatability(relic.getDescription(), this.shouldBeRepeatable);
    }

    @Test
    public void withRepeatableIterable() throws Exception {
        Relic relic = (Relic)this.flowRunner("firstElementOfRepeatableIterable").run().getMessage().getPayload().getValue();
        this.assertValueRepeatability(relic.getDescription(), true);
    }

    protected void assertValueRepeatability(Object value, boolean shouldBeRepeatable) {
        if (shouldBeRepeatable) {
            MatcherAssert.assertThat((Object)value, (Matcher)IsInstanceOf.instanceOf(CursorStreamProvider.class));
        } else {
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(CursorStreamProvider.class)));
        }
    }
}

