/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Every;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreOperationsWithFailures;

public class PetStoreRetryPolicyProviderConnectionTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Transaction transaction;

    protected String getConfigFile() {
        return "petstore-retry-policy.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Before
    public void before() {
        PetStoreOperationsWithFailures.resetConnectionThreads();
    }

    @After
    public void after() throws TransactionException {
        PetStoreOperationsWithFailures.resetConnectionThreads();
        if (this.transaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(this.transaction);
        }
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionExecutingOperation() throws Exception {
        this.flowRunner("fail-operation-with-connection-exception").runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)PetStoreOperationsWithFailures.getConnectionThreads(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(PetStoreOperationsWithFailures.getConnectionThreads().stream().map(t -> t.getThreadGroup()).collect(Collectors.toSet()), (Matcher)Every.everyItem((Matcher)Matchers.sameInstance((Object)SimpleUnitTestSupportSchedulerService.UNIT_TEST_THREAD_GROUP)));
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionAtValidateTime() throws Exception {
        this.flowRunner("fail-connection-validation").runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)PetStoreOperationsWithFailures.getConnectionThreads(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(PetStoreOperationsWithFailures.getConnectionThreads().stream().map(t -> t.getThreadGroup()).collect(Collectors.toSet()), (Matcher)Every.everyItem((Matcher)Matchers.sameInstance((Object)SimpleUnitTestSupportSchedulerService.UNIT_TEST_THREAD_GROUP)));
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionExecutingOperationTxFlow() throws Exception {
        this.transaction = this.createTransactionMock();
        this.flowRunner("fail-operation-with-connection-exception").transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, (TransactionFactory)new TestTransactionFactory(this.transaction)).runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)PetStoreOperationsWithFailures.getConnectionThreads(), (Matcher)Matchers.hasSize((int)3));
        Set connectionThreadsSet = PetStoreOperationsWithFailures.getConnectionThreads().stream().map(t -> t.getThreadGroup()).collect(Collectors.toSet());
        Assert.assertThat((String)"Transactional retry must not change threads", connectionThreadsSet, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(connectionThreadsSet, (Matcher)Every.everyItem((Matcher)Matchers.sameInstance((Object)Thread.currentThread().getThreadGroup())));
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionAtValidateTimeTxFlow() throws Exception {
        this.transaction = this.createTransactionMock();
        this.flowRunner("fail-connection-validation").transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, (TransactionFactory)new TestTransactionFactory(this.transaction)).runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)PetStoreOperationsWithFailures.getConnectionThreads(), (Matcher)Matchers.hasSize((int)3));
        Set connectionThreadsSet = PetStoreOperationsWithFailures.getConnectionThreads().stream().map(t -> t.getThreadGroup()).collect(Collectors.toSet());
        Assert.assertThat((String)"Transactional retry must not change threads", connectionThreadsSet, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(connectionThreadsSet, (Matcher)Every.everyItem((Matcher)Matchers.sameInstance((Object)Thread.currentThread().getThreadGroup())));
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionExecutingOperationTxOperation() throws Exception {
        this.flowRunner("fail-operation-with-connection-exception-tx").runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)PetStoreOperationsWithFailures.getConnectionThreads(), (Matcher)Matchers.hasSize((int)3));
        Set connectionThreadsSet = PetStoreOperationsWithFailures.getConnectionThreads().stream().map(t -> t.getThreadGroup()).collect(Collectors.toSet());
        Assert.assertThat((String)"Transactional retry must not change threads", connectionThreadsSet, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(connectionThreadsSet, (Matcher)Every.everyItem((Matcher)Matchers.sameInstance((Object)SimpleUnitTestSupportSchedulerService.UNIT_TEST_THREAD_GROUP)));
    }

    @Test
    public void retryPolicyExhaustedDueToInvalidConnectionAtValidateTimeTxOperation() throws Exception {
        this.flowRunner("fail-connection-validation-tx").runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)PetStoreOperationsWithFailures.getConnectionThreads(), (Matcher)Matchers.hasSize((int)3));
        Set connectionThreadsSet = PetStoreOperationsWithFailures.getConnectionThreads().stream().map(t -> t.getThreadGroup()).collect(Collectors.toSet());
        Assert.assertThat((String)"Transactional retry must not change threads", connectionThreadsSet, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(connectionThreadsSet, (Matcher)Every.everyItem((Matcher)Matchers.sameInstance((Object)SimpleUnitTestSupportSchedulerService.UNIT_TEST_THREAD_GROUP)));
    }

    private Transaction createTransactionMock() throws TransactionException {
        TransactionAdapter transaction = (TransactionAdapter)Mockito.mock(TransactionAdapter.class);
        ((TransactionAdapter)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
            return null;
        }).when((Object)transaction)).begin();
        Mockito.when((Object)transaction.getComponentLocation()).thenReturn(Optional.empty());
        return transaction;
    }

    @Test
    public void retryPolicyNotExecutedDueToNotConnectionExceptionWithException() throws Exception {
        this.flowRunner("fail-operation-with-not-handled-exception").runExpectingException();
    }

    @Test
    public void retryPolicyNotExecutedDueToNotConnectionExceptionWithThrowable() throws Throwable {
        this.flowRunner("fail-operation-with-not-handled-throwable").runExpectingException();
    }
}

