/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tck.junit4.matcher.ValueMatcher;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class OperationValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/operation-values.xml";
    }

    @Test
    public void singleOptions() throws Exception {
        Set<Value> channels = this.getValues("single-values-enabled-parameter", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void singleOptionsEnabledParameterWithConnection() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterWithConnection", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("connection1", "connection2", "connection3"));
    }

    @Test
    public void singleOptionsEnabledParameterWithConfiguration() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterWithConfiguration", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("config1", "config2", "config3"));
    }

    @Test
    public void singleOptionsEnabledParameterWithRequiredParameters() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterWithRequiredParameters", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:aString"));
    }

    @Test
    public void singleOptionsEnabledParameterWithRequiredParametersUsingExpressions() throws Exception {
        Set<Value> channels = this.getValues("singleOptionsEnabledParameterWithRequiredParametersUsingExpressions", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:aString"));
    }

    @Test
    public void singleOptionsEnabledParameterWithMissingRequiredParameters() throws Exception {
        ValueResult valueResult = this.getValueResult("singleOptionsEnabledParameterWithMissingRequiredParameters", "channels");
        MatcherAssert.assertThat((Object)valueResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ResolvingFailure)valueResult.getFailure().get()).getFailureCode(), (Matcher)CoreMatchers.is((Object)"MISSING_REQUIRED_PARAMETERS"));
    }

    @Test
    public void singleOptionsEnabledParameterWithOptionalParameter() throws Exception {
        Set<Value> channels = this.getValues("singleOptionsEnabledParameterWithOptionalParameter", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat(channels, this.hasValues("requiredInteger:2", "requiredBoolean:false", "strings:[1, 2]", "requiredString:null"));
    }

    @Test
    public void singleOptionsEnabledParameterInsideParameterGroup() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterInsideParameterGroup", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat(channels, this.hasValues("channel1", "channel2", "channel3"));
    }

    @Test
    public void singleOptionsEnabledParameterRequiresValuesOfParameterGroup() throws Exception {
        Set<Value> channels = this.getValues("singleValuesEnabledParameterRequiresValuesOfParameterGroup", "values");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("anyParameter:aParam"));
    }

    @Test
    public void multiLevelOption() throws Exception {
        Set<Value> values = this.getValues("multiLevelValue", "values");
        ValueMatcher americaValue = ValueMatcher.valueWithId((String)"America").withDisplayName("America").withPartName("continent").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Argentina").withDisplayName("Argentina").withPartName("country").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"Buenos Aires").withDisplayName("Buenos Aires").withPartName("city")})});
        MatcherAssert.assertThat(values, this.hasValues(americaValue));
    }

    @Test
    public void singleOptionsWithRequiredParameterWithAlias() throws Exception {
        Set<Value> channels = this.getValues("singleValuesWithRequiredParameterWithAlias", "channels");
        MatcherAssert.assertThat(channels, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(channels, this.hasValues("requiredString:dummyValue"));
    }

    @Test
    public void resolverGetsMuleContextInjection() throws Exception {
        Set<Value> values = this.getValues("resolverGetsMuleContextInjection", "channel");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("INJECTED!!!"));
    }

    @Test
    public void optionsInsideShowInDslGroup() throws Exception {
        Set<Value> values = this.getValues("valuesInsideShowInDslGroup", "values");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void optionsInsideShowInDslDynamicGroup() throws Exception {
        Set<Value> values = this.getValues("valuesInsideShowInDslDynamicGroup", "values");
        MatcherAssert.assertThat(values, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat(values, this.hasValues("anyParameter:someValue"));
    }

    @Test
    public void userErrorWhenResolvingValues() throws Exception {
        ValueResult result = this.getValueResult("withErrorValueProvider", "values");
        MatcherAssert.assertThat((Object)result.getFailure().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ResolvingFailure resolvingFailure = (ResolvingFailure)result.getFailure().get();
        MatcherAssert.assertThat((Object)resolvingFailure.getFailureCode(), (Matcher)CoreMatchers.is((Object)"CUSTOM_ERROR"));
        MatcherAssert.assertThat((Object)resolvingFailure.getMessage(), (Matcher)CoreMatchers.is((Object)"Error!!!"));
    }
}

