/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.transaction.xa.IllegalTransactionStateException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.transactional.connection.TestLocalTransactionalConnection;

public class TransactionalOperationTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "transaction-config.xml";
    }

    @Test
    public void commited() throws Exception {
        ((FlowRunner)this.flowRunner("commitLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void rolledBack() throws Exception {
        ((FlowRunner)this.flowRunner("rollbackLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void executeTransactionless() throws Exception {
        TestLocalTransactionalConnection connection = (TestLocalTransactionalConnection)((FlowRunner)this.flowRunner("executeTransactionless").withPayload((Object)"")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)connection.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)connection.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)connection.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void localTxDoesntSupportMultipleResources() throws Exception {
        this.flowRunner("localTxDoesntSupportMultipleResources").runExpectingException(Matchers.allOf((Matcher)CoreMatchers.instanceOf(TransactionException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"the current transaction doesn't support it and could not be bound"))));
    }

    @Test
    public void localTxSupportsMultipleOperationsFromSameResource() throws Exception {
        this.flowRunner("localTxSupportsMultipleOperationsFromSameResource").run();
    }

    @Test
    public void pagedOperationInTx() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationInTx").run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        Assert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        Assert.assertThat((Object)id1, (Matcher)CoreMatchers.equalTo((Object)id2));
    }

    @Test
    public void pagedOperationWithoutTx() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationWithoutTx").run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        Assert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        Assert.assertThat((Object)id1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)id2)));
    }

    @Test
    public void cantNestTransactions() throws Exception {
        this.expectedException.expectMessage("Non-XA transactions can't be nested.");
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IllegalTransactionStateException.class)));
        this.flowRunner("cantNestTransactions").run();
    }

    @Test
    public void operationJoinsAlreadyCreatedTx() throws Exception {
        this.flowRunner("operationJoinsAlreadyCreatedTx").run();
    }
}

