/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=MockitoJUnitRunner.class)
public class PetstoreSecurityContextTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String MOCK_PROVIDER = "MockProvider";
    private static final String NULL_PROVIDER = "NullProvider";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SecurityProvider provider;
    @Mock
    private SecurityContext securityContext;
    @Mock
    private Authentication authenticationResult;

    protected String getConfigFile() {
        return "petstore-security-context-handler.xml";
    }

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.provider.getName()).thenReturn((Object)MOCK_PROVIDER);
        Mockito.when((Object)this.provider.authenticate((Authentication)ArgumentMatchers.any(Authentication.class))).thenReturn((Object)this.authenticationResult);
        Mockito.when((Object)this.provider.createSecurityContext(this.authenticationResult)).thenReturn((Object)this.securityContext);
        Mockito.when((Object)this.provider.supports((Class)ArgumentMatchers.any())).thenReturn((Object)true);
        SecurityProvider nullProvider = (SecurityProvider)Mockito.mock(SecurityProvider.class);
        Mockito.when((Object)nullProvider.getName()).thenReturn((Object)NULL_PROVIDER);
        Mockito.when((Object)nullProvider.authenticate((Authentication)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)nullProvider.createSecurityContext((Authentication)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)nullProvider.supports((Class)ArgumentMatchers.any())).thenReturn((Object)false);
        muleContext.getSecurityManager().addProvider(this.provider);
        muleContext.getSecurityManager().addProvider(nullProvider);
    }

    @Test
    public void changedSecurityContext() throws Exception {
        SecurityContext context = this.flowRunner("setSecureCage").run().getSecurityContext();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.is((Object)this.securityContext));
    }

    @Test
    public void filteredProviders() throws Exception {
        SecurityContext context = ((FlowRunner)this.flowRunner("setSecureCageFilterProviders").withVariable("providers", Arrays.asList(MOCK_PROVIDER))).run().getSecurityContext();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.is((Object)this.securityContext));
    }

    @Test
    public void filteredProvidersExpectedException() throws Exception {
        this.expectedException.expectCause(Matchers.instanceOf(SecurityProviderNotFoundException.class));
        SecurityContext context = ((FlowRunner)this.flowRunner("setSecureCageFilterProviders").withVariable("providers", Arrays.asList("Invalid"))).run().getSecurityContext();
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)context, (Matcher)Matchers.is((Object)this.securityContext));
    }
}

