/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.FailingPetStoreSource;
import org.mule.test.petstore.extension.PetStoreConnector;

public class PetStoreSourceRetryPolicyProviderTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int TIMEOUT_MILLIS = 10000;
    public static final int POLL_DELAY_MILLIS = 50;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    protected String getConfigFile() {
        return "petstore-source-retry-policy.xml";
    }

    protected void doSetUp() throws Exception {
        PetStoreConnector.timesStarted = 0;
        FailingPetStoreSource.failedDueOnException = false;
        super.doSetUp();
    }

    protected void doTearDown() throws Exception {
        PetStoreConnector.timesStarted = 0;
        FailingPetStoreSource.failedDueOnException = false;
        if (FailingPetStoreSource.executor != null) {
            FailingPetStoreSource.executor.shutdownNow();
        }
        super.doTearDown();
    }

    @Test
    public void retryPolicySourceFailOnStart() throws Exception {
        this.exception.expect(RetryPolicyExhaustedException.class);
        this.exception.expectCause(CoreMatchers.sameInstance((Object)FailingPetStoreSource.connectionException));
        try {
            this.startFlow("source-fail-on-start");
        }
        catch (Exception e) {
            PollingProber.probe((long)10000L, (long)50L, () -> {
                Assert.assertThat((Object)PetStoreConnector.timesStarted, (Matcher)Matchers.is((Object)2));
                return true;
            });
            throw e;
        }
    }

    @Test
    public void retryPolicySourceFailWithConnectionException() throws Exception {
        this.startFlow("source-fail-with-connection-exception");
        PollingProber.probe((long)10000L, (long)50L, () -> {
            Assert.assertThat((Object)PetStoreConnector.timesStarted, (Matcher)Matchers.is((Object)3));
            return true;
        });
    }

    @Test
    public void retryPolicySourceFailOnStartFallbackToConnection() throws Exception {
        this.exception.expect(RetryPolicyExhaustedException.class);
        this.exception.expectCause(CoreMatchers.sameInstance((Object)FailingPetStoreSource.connectionException));
        try {
            this.startFlow("source-fail-on-start-fallback-to-connection");
        }
        catch (Exception e) {
            PollingProber.probe((long)10000L, (long)50L, () -> {
                Assert.assertThat((Object)PetStoreConnector.timesStarted, (Matcher)Matchers.is((Object)2));
                return true;
            });
            throw e;
        }
    }

    @Test
    public void retryPolicySourceFailWithConnectionExceptionFallbackToConnection() throws Exception {
        this.startFlow("source-fail-with-connection-exception-fallback-to-connection");
        PollingProber.probe((long)10000L, (long)50L, () -> {
            Assert.assertThat((Object)PetStoreConnector.timesStarted, (Matcher)Matchers.is((Object)3));
            return true;
        });
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }
}

