/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class PetStorePooledConnectionEvictionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static int AMOUNT_OF_TRIES = 2;
    private static int TIME_BETWEEN_TRIES_IN_MILLIS = 4000;
    private static Long IMPOSSIBLE_CONNECTION_AGE = 3000L;

    protected String getConfigFile() {
        return "petstore-pooled-connection-eviction.xml";
    }

    @Test
    public void connectionIsEvicted() throws Exception {
        ArrayList<Long> connectionAgesAtExecution = new ArrayList<Long>();
        for (int i = 0; i < AMOUNT_OF_TRIES; ++i) {
            connectionAgesAtExecution.add((Long)this.flowRunner("get-connection-age").run().getMessage().getPayload().getValue());
            Thread.sleep(TIME_BETWEEN_TRIES_IN_MILLIS);
        }
        for (Long connectionAgeAtExecution : connectionAgesAtExecution) {
            MatcherAssert.assertThat((Object)connectionAgeAtExecution, (Matcher)Matchers.not((Matcher)Matchers.greaterThan((Comparable)IMPOSSIBLE_CONNECTION_AGE)));
        }
    }
}

