/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.heisenberg.extension.model.types.IntegerAttributes;
import org.mule.test.heisenberg.extension.model.types.WeaponType;
import org.mule.test.module.extension.AbstractHeisenbergConfigTestCase;
import org.mule.test.vegan.extension.VeganPolicy;

@Feature(value="EXTENSIONS_CLIENT")
public abstract class ExtensionsClientTestCase
extends AbstractHeisenbergConfigTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final String HEISENBERG_EXT_NAME = "Heisenberg";
    private static final String HEISENBERG_CONFIG = "heisenberg";
    private static final String ALIAS_OUTPUT = "jeje, my name is Juani and I'm 23 years old";
    private static final String ANOTHER_ALIAS_OUTPUT = "jeje, my name is Heisenberg and I'm 23 years old";
    @Inject
    protected ExtensionsClient client;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        HeisenbergOperations.disposed = false;
    }

    protected boolean isDisposeContextPerClass() {
        return false;
    }

    @After
    public void after() {
        HeisenbergOperations.disposed = false;
    }

    protected String[] getConfigFiles() {
        return new String[]{"vegan-config.xml", "heisenberg-config.xml"};
    }

    abstract <T, A> Result<T, A> doExecute(String var1, String var2, OperationParameters var3) throws Throwable;

    @Test
    @Description(value="Executes a simple operation using the client and checks the output")
    public void executeSimpleOperation() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).addParameter("victim", (Object)"Juani").addParameter("goodbyeMessage", (Object)"ADIOS").build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "kill", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"ADIOS, Juani"));
    }

    @Test
    @Description(value="Executes a simple operation twice using the client and checks the output")
    public void executeSimpleOperationTwice() throws Throwable {
        this.executeSimpleOperation();
        this.executeSimpleOperation();
    }

    @Test
    @Description(value="Executes a simple operation with an expression as parameter using the client and checks the output")
    public void executeSimpleOperationWithExpression() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).addParameter("victim", (Object)"#[mel:'Juani']").addParameter("goodbyeMessage", (Object)"ADIOS").build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "kill", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"ADIOS, Juani"));
    }

    @Test
    @Description(value="Executes an operation with a complex type parameter using the client and the DefaultOperationParametersBuilder")
    public void executeOperationWithComplexType() throws Throwable {
        Weapon.WeaponAttributes attributes = new Weapon.WeaponAttributes();
        attributes.setBrand("brand");
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).addParameter("weapon", Ricin.class, DefaultOperationParameters.builder().addParameter("destination", KnockeableDoor.class, DefaultOperationParameters.builder().addParameter("address", (Object)"ADdresss").addParameter("victim", (Object)"victim!1231")).addParameter("microgramsPerKilo", (Object)123L)).addParameter("type", (Object)WeaponType.FIRE_WEAPON).addParameter("attributesOfWeapon", (Object)attributes).build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "killWithWeapon", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"Killed with: You have been killed with Ricin , Type FIRE_WEAPON and attribute brand"));
    }

    @Test
    @Description(value="Executes an operation that has a parameter group using the client and checks the output")
    public void executeOperationWithParameterGroup() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).addParameter("greeting", (Object)"jeje").addParameter("age", (Object)23).addParameter("myName", (Object)"Juani").addParameter("knownAddresses", Collections.emptyList()).build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "alias", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)ALIAS_OUTPUT));
    }

    @Test
    @Description(value="Executes an operation that has a parameter group using the client and checks the output")
    public void executeOperationWithParameterGroupUsingOptional() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).addParameter("greeting", (Object)"jeje").addParameter("age", (Object)23).addParameter("knownAddresses", Collections.emptyList()).build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "alias", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)ANOTHER_ALIAS_OUTPUT));
    }

    @Test
    @Description(value="Executes a simple operation twice with different parameters using the client and checks the output")
    public void executeSimpleOperationTwiceWithDifferentParameters() throws Throwable {
        this.executeOperationWithParameterGroup();
        this.executeOperationWithParameterGroupUsingOptional();
    }

    @Test
    @Description(value="Executes a two different operationsusing the client and checks the output")
    public void executeTwoDifferentOperation() throws Throwable {
        this.executeOperationWithParameterGroup();
        this.executeSimpleOperation();
    }

    @Test
    @Description(value="Executes an operation that has a parameter with default value using the client and checks the output")
    public void executeOperationWithDefaultValueParameter() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName("apple").build();
        Result result = this.doExecute("vegan", "tryToEatThisListOfMaps", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.instanceOf(List.class));
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    @Description(value="Executes an operation that has a @NullSafe annotated parameter using the client and checks the output")
    public void executeOperationWithNullSafeParameter() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName("banana").build();
        Result result = this.doExecute("vegan", "applyPolicy", (OperationParameters)params);
        MatcherAssert.assertThat((Object)((VeganPolicy)result.getOutput()).getMeetAllowed(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((VeganPolicy)result.getOutput()).getIngredients().getSaltMiligrams(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Description(value="Executes an operation that returns attributes metadata using the client and checks the output and the attributes")
    public void executeOperationThatReturnsAttributes() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "getEnemy", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"Gustavo Fring"));
        MatcherAssert.assertThat((Object)result.getAttributes().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((IntegerAttributes)result.getAttributes().get()).getValue(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Description(value="Executes a void operation using the client")
    public void executeVoidOperation() throws Throwable {
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).build();
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "die", (OperationParameters)params);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)result.getAttributes().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @Description(value="Executes an operation that fails using the client and checks the throwed exception")
    public void executeFailureOperation() throws Throwable {
        this.exception.expect(MuleException.class);
        this.exception.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.exception.expectMessage("You are not allowed to speak with gus.");
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).build();
        this.doExecute(HEISENBERG_EXT_NAME, "callGusFring", (OperationParameters)params);
    }

    @Test
    @Description(value="Executes an operation that fails using the client and checks the throwed exception")
    public void executeFailureNonBlockingOperation() throws Throwable {
        this.exception.expect(MuleException.class);
        this.exception.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.exception.expectMessage("You are not allowed to speak with gus.");
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(HEISENBERG_CONFIG).build();
        this.doExecute(HEISENBERG_EXT_NAME, "callGusFringNonBlocking", (OperationParameters)params);
    }

    @Test
    @Description(value="Tries to execute an operation from an extension that does not exist")
    public void nonExistentExtension() throws Throwable {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("No Extension [no-exist] Found");
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName("config").build();
        this.doExecute("no-exist", "operation", (OperationParameters)params);
    }

    @Test
    @Description(value="Tries to execute an operation that does not exist")
    public void nonExistentOperation() throws Throwable {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("No Operation [operationDontExist] Found");
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName("config").build();
        this.doExecute("vegan", "operationDontExist", (OperationParameters)params);
    }

    @Test
    @Description(value="Tries to execute an operation with a configuration that does not exist")
    public void nonExistentConfiguration() throws Throwable {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("No configuration [configDontExist] found");
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName("configDontExist").build();
        this.doExecute("vegan", "applyPolicy", (OperationParameters)params);
    }

    @Test
    @Description(value="Checks that an operation disposes the resources after terminated")
    public void disposeAfterExecution() throws Throwable {
        this.executeSimpleOperation();
        if (this.usingCachedStrategy()) {
            muleContext.dispose();
        }
        MatcherAssert.assertThat((Object)HeisenbergOperations.disposed, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Checks that an operation disposes the resources when an error occurred while executing")
    public void disposeOnFailureOperation() throws Throwable {
        this.executeFailureOperation();
        MatcherAssert.assertThat((Object)HeisenbergOperations.disposed, (Matcher)CoreMatchers.is((Object)true));
    }

    private boolean usingCachedStrategy() {
        return !Boolean.parseBoolean(System.getProperty("mule.extensionsClient.disableCache"));
    }
}

