/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.classloading;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.StringContains;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.TestConnectivityUtils;
import org.mule.test.classloading.api.ClassLoadingHelper;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ClassLoadingOnConnectionsTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public SystemProperty disableTestConnectivity = TestConnectivityUtils.disableAutomaticTestConnectivity();

    @Before
    public void setUp() {
        ClassLoadingHelper.createdClassLoaders.clear();
    }

    protected String getConfigFile() {
        return "classloading/classloading-extension-config.xml";
    }

    @Test
    public void noneConnectionProvider() throws Exception {
        this.flowRunner("none-operation").run();
        this.verifyUsedClassLoaders("Connect", "Disconnect");
    }

    @Test
    public void cachedConnectionProvider() throws Exception {
        this.flowRunner("cached-operation").run();
        this.verifyUsedClassLoaders("Connect");
    }

    @Test
    public void poolingConnectionProvider() throws Exception {
        this.flowRunner("pooling-operation").run();
        this.verifyUsedClassLoaders("Connect", "OnBorrow", "OnReturn");
    }

    void verifyUsedClassLoaders(String ... phasesToExecute) {
        Map createdClassLoaders = ClassLoadingHelper.createdClassLoaders;
        List collect = createdClassLoaders.values().stream().distinct().collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collect.size(), (Matcher)CoreMatchers.is((Object)1));
        ClassLoader classLoader = (ClassLoader)collect.get(0);
        MatcherAssert.assertThat((Object)classLoader.toString(), (Matcher)AllOf.allOf((Matcher)StringContains.containsString((String)"classloading-extension"), (Matcher)StringContains.containsString((String)".TestRegionClassLoader[Region] @")));
        Set executedPhases = createdClassLoaders.keySet();
        MatcherAssert.assertThat(executedPhases, (Matcher)CoreMatchers.is((Matcher)IsCollectionContaining.hasItems((Matcher[])((Matcher[])Arrays.stream(phasesToExecute).map(StringContains::containsString).toArray(Matcher[]::new)))));
    }
}

