/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.util.Collections;
import java.util.Optional;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.resources.manifest.ExportedArtifactsCollector;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;

public class MulePluginDescriptorGenerator
implements GeneratedResourceFactory {
    public Optional<GeneratedResource> generateResource(ExtensionModel extensionModel) {
        Optional typeProperty = extensionModel.getModelProperty(ImplementingTypeModelProperty.class);
        if (!typeProperty.isPresent()) {
            return Optional.empty();
        }
        ExportedArtifactsCollector exportCollector = new ExportedArtifactsCollector(extensionModel);
        MulePluginModel.MulePluginModelBuilder builder = new MulePluginModel.MulePluginModelBuilder();
        ((MulePluginModel.MulePluginModelBuilder)builder.setName(extensionModel.getName())).setMinMuleVersion(extensionModel.getMinMuleVersion().toCompleteNumericVersion());
        builder.withClassLoaderModelDescriber().setId("maven").addProperty("exportedPackages", (Object)exportCollector.getExportedPackages()).addProperty("exportedResources", (Object)exportCollector.getExportedResources()).addProperty("privilegedExportedPackages", (Object)exportCollector.getPrivilegedExportedPackages()).addProperty("privilegedArtifactIds", (Object)exportCollector.getPrivilegedArtifacts());
        builder.withExtensionModelDescriber().setId(this.getLoaderId(extensionModel)).addProperty("type", (Object)((ImplementingTypeModelProperty)typeProperty.get()).getType().getName()).addProperty("version", (Object)extensionModel.getVersion());
        builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("maven", Collections.emptyMap()));
        String descriptorJson = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)builder.build());
        return Optional.of(new GeneratedResource("mule-artifact.json", descriptorJson.getBytes()));
    }

    private String getLoaderId(ExtensionModel extensionModel) {
        Optional soapModelProperty = extensionModel.getModelProperty(SoapExtensionModelProperty.class);
        return soapModelProperty.isPresent() ? "soap" : "java";
    }
}

