/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ConfigurationDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.OperationDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.SourcesDescriptionDocumenter;

final class ExtensionDescriptionDocumenter
extends AbstractDescriptionDocumenter<ExtensionDeclaration> {
    private final RoundEnvironment roundEnv;
    private final ConfigurationDescriptionDocumenter configDeclarer;
    private final OperationDescriptionDocumenter operationDeclarer;
    private final SourcesDescriptionDocumenter sourceDeclarer;

    ExtensionDescriptionDocumenter(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment) {
        super(processingEnvironment);
        this.roundEnv = roundEnvironment;
        this.operationDeclarer = new OperationDescriptionDocumenter(this.processingEnv);
        this.sourceDeclarer = new SourcesDescriptionDocumenter(this.processingEnv);
        this.configDeclarer = new ConfigurationDescriptionDocumenter(processingEnvironment);
    }

    @Override
    void document(ExtensionDeclaration extensionDeclaration, TypeElement extensionElement) {
        Extension annotation = extensionElement.getAnnotation(Extension.class);
        extensionDeclaration.setDescription(annotation.description());
        this.sourceDeclarer.document((WithSourcesDeclaration<?>)extensionDeclaration, extensionElement);
        this.operationDeclarer.document((WithOperationsDeclaration<?>)extensionDeclaration, extensionElement);
        this.documentConfigurations(extensionDeclaration, extensionElement);
    }

    private void documentConfigurations(ExtensionDeclaration declaration, TypeElement extensionElement) {
        Set<TypeElement> configurations = processor.getTypeElementsAnnotatedWith(Configuration.class, this.roundEnv);
        if (!configurations.isEmpty()) {
            configurations.forEach(config -> this.findMatchingConfiguration(declaration, (TypeElement)config).ifPresent(configDeclaration -> this.configDeclarer.document((ConfigurationDeclaration)configDeclaration, (TypeElement)config)));
        } else {
            this.configDeclarer.document((ConfigurationDeclaration)declaration.getConfigurations().get(0), extensionElement);
        }
    }

    private Optional<ConfigurationDeclaration> findMatchingConfiguration(ExtensionDeclaration declaration, TypeElement element) {
        List configurations = declaration.getConfigurations();
        if (configurations.size() == 1) {
            return Optional.of(configurations.get(0));
        }
        return configurations.stream().filter(config -> {
            Configuration configurationAnnotation = element.getAnnotation(Configuration.class);
            String name = config.getName();
            String annotationName = configurationAnnotation != null ? configurationAnnotation.name() : "";
            String defaultNaming = NameUtils.hyphenize((String)element.getSimpleName().toString());
            return name.equals(defaultNaming) || name.equals(annotationName) || name.equals("config");
        }).findAny();
    }
}

