/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.connection;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.connection.ErrorTypeHandlerConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.config.BaseConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.soap.api.runtime.connection.transport.DefaultHttpMessageDispatcherProvider;
import org.mule.runtime.module.extension.soap.internal.loader.SoapServiceProviderDeclarer;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClientConnectionProvider;
import org.mule.runtime.soap.api.client.SoapClient;

public final class SoapConnectionProviderObjectBuilder
extends BaseConnectionProviderObjectBuilder<SoapClient> {
    private final DefaultResolverSetBasedObjectBuilder<SoapServiceProvider> objectBuilder;

    public SoapConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(providerModel, SoapConnectionProviderObjectBuilder.getServiceProviderType(providerModel), resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
        this.objectBuilder = new DefaultResolverSetBasedObjectBuilder(SoapConnectionProviderObjectBuilder.getServiceProviderType(providerModel), resolverSet, expressionManager, muleContext);
    }

    public Pair<ConnectionProvider<SoapClient>, ResolverSetResult> build(ResolverSetResult result) throws MuleException {
        SoapServiceProvider serviceProvider = (SoapServiceProvider)this.objectBuilder.build(result);
        MessageDispatcherProvider<MessageDispatcher> transport = this.getCustomTransport(result);
        ForwardingSoapClientConnectionProvider provider = new ForwardingSoapClientConnectionProvider(serviceProvider, transport, this.muleContext);
        provider = new ReconnectableConnectionProviderWrapper((ConnectionProvider)provider, this.reconnectionConfig);
        provider = new ErrorTypeHandlerConnectionProviderWrapper((ConnectionProvider)provider, this.extensionModel, this.reconnectionConfig, this.muleContext.getErrorTypeRepository());
        return new Pair((Object)provider, (Object)result);
    }

    private MessageDispatcherProvider<MessageDispatcher> getCustomTransport(ResolverSetResult resultSet) {
        MessageDispatcherProvider customTransport = (MessageDispatcherProvider)resultSet.get(SoapServiceProviderDeclarer.TRANSPORT_PARAM);
        return customTransport != null ? customTransport : new DefaultHttpMessageDispatcherProvider();
    }

    private static Class<SoapServiceProvider> getServiceProviderType(ConnectionProviderModel model) {
        return model.getModelProperty(ImplementingTypeModelProperty.class).map(prop -> prop.getType()).orElseThrow(() -> new IllegalStateException(String.format("No %s was defined in connection provider [%s]", ImplementingTypeModelProperty.class.getSimpleName(), model.getName())));
    }

    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }
}

