/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.connection.transport;

import java.util.Objects;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.soap.HttpMessageDispatcherProvider;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.soap.api.message.dispatcher.DefaultHttpMessageDispatcher;
import org.mule.runtime.soap.api.message.dispatcher.HttpConfigBasedMessageDispatcher;

public class DefaultHttpMessageDispatcherProvider
implements HttpMessageDispatcherProvider,
Lifecycle {
    @Inject
    private HttpService httpService;
    @Inject
    private ExtensionsClient extensionsClient;
    @Parameter
    @Optional
    private String requesterConfig;
    private HttpClient httpClient;

    public MessageDispatcher connect() throws ConnectionException {
        return Objects.isNull(this.requesterConfig) ? new DefaultHttpMessageDispatcher(this.httpClient) : new HttpConfigBasedMessageDispatcher(this.requesterConfig, this.extensionsClient);
    }

    public void disconnect(MessageDispatcher connection) {
        connection.dispose();
    }

    public ConnectionValidationResult validate(MessageDispatcher connection) {
        return ConnectionValidationResult.success();
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName("soap-ext-dispatcher").build());
    }

    public void stop() throws MuleException {
        this.httpClient.stop();
    }

    public void start() throws MuleException {
        this.httpClient.start();
    }
}

