/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.function.HasFunctionModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.skyscreamer.jsonassert.JSONAssert;

@Feature(value="Reuse")
@Story(value="Application Extension Model")
public class ApplicationAsExtensionModelTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private ExtensionManager extensionManager;
    private final ExtensionModelJsonSerializer serializer = new ExtensionModelJsonSerializer(true);
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionModelJson.updateExpectedFilesOnError");

    protected String getConfigFile() {
        return "app-as-mule-extension.xml";
    }

    @Test
    public void loadApplicationExtensionModel() throws Exception {
        ExtensionModel extensionModel = this.getAppExtensionModel();
        String actual = this.serializer.serialize(extensionModel);
        String expectedSerializedPath = "models/app-as-mule-extension.json";
        String expected = IOUtils.getResourceAsString((String)"models/app-as-mule-extension.json", ((Object)((Object)this)).getClass());
        try {
            JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
        }
        catch (AssertionError e) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                this.updateExpectedJson("models/app-as-mule-extension.json", actual);
            }
            LOGGER.error(actual);
            throw e;
        }
    }

    @Test
    public void flowIsIgnored() {
        ExtensionModel extensionModel = this.getAppExtensionModel();
        new ExtensionWalker(){

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onConfiguration(ConfigurationModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onFunction(HasFunctionModels owner, FunctionModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }
        }.walk(extensionModel);
    }

    private void assertNotFlow(NamedObject named) {
        MatcherAssert.assertThat((Object)named.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"superfluousFlow"))));
    }

    private ExtensionModel getAppExtensionModel() {
        return (ExtensionModel)this.extensionManager.getExtension(muleContext.getConfiguration().getId()).get();
    }

    private String getResource(String path) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        Preconditions.checkArgument((in != null ? 1 : 0) != 0, (String)("Resource not found: " + path));
        return IOUtils.toString((InputStream)in);
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    private void updateExpectedJson(String expectedJsonPath, String json) throws URISyntaxException, IOException {
        File root = new File(IOUtils.getResourceAsUrl((String)expectedJsonPath, ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile().getParentFile();
        File testDir = new File(root, "src/test/resources/");
        File target = new File(testDir, expectedJsonPath);
        FileUtils.stringToFile((String)target.getAbsolutePath(), (String)json);
        LOGGER.info(target.getAbsolutePath() + " was fixed");
    }
}

