/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;

@Feature(value="Reuse")
@Stories(value={@Story(value="Application Extension Model"), @Story(value="Operations")})
@Issue(value="W-11292607")
public class DeprecationAstTestCase
extends AbstractMuleSdkAstTestCase {
    @Override
    protected String getConfigFile() {
        return "mule-deprecations-config.xml";
    }

    @Test
    public void operationDeprecation() {
        ArtifactAst appAst = this.getArtifactAst();
        ComponentAst deprecatedOperationAst = this.getTopLevelComponent(appAst, "deprecatedOperation");
        ComponentAst deprecationAst = this.getChild(deprecatedOperationAst, "deprecated");
        ComponentModel deprecationComponentModel = (ComponentModel)deprecationAst.getModel(ComponentModel.class).get();
        Assert.assertThat((Object)deprecationComponentModel.getDescription(), (Matcher)Matchers.is((Object)"Defines an operation's deprecation."));
    }

    @Test
    public void parameterDeprecation() {
        ArtifactAst appAst = this.getArtifactAst();
        ComponentAst operationWithDeprecatedParameter = this.getTopLevelComponent(appAst, "operationWithDeprecatedParameter");
        ComponentAst parametersAst = this.getChild(operationWithDeprecatedParameter, "parameters");
        ComponentAst deprecatedParameterAst = this.getChild(parametersAst, "parameter");
        ComponentAst deprecationAst = this.getChild(deprecatedParameterAst, "deprecated");
        ComponentModel deprecationComponentModel = (ComponentModel)deprecationAst.getModel(ComponentModel.class).get();
        Assert.assertThat((Object)deprecationComponentModel.getDescription(), (Matcher)Matchers.is((Object)"Defines a parameter's deprecation."));
    }
}

