/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.HashSet;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.matcher.EventMatcher;

@Feature(value="Reuse")
@Stories(value={@Story(value="Operations"), @Story(value="Error Handling")})
public class MuleOperationErrorHandlingTestCase
extends MuleArtifactFunctionalTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"mule-error-handling-operations-config.xml", "mule-error-handling-with-try-operations-config.xml", "reusing-error-handling-mule-config.xml"};
    }

    @Test
    public void errorWithinAppWithNamespaceThis() throws Exception {
        this.flowRunner("raiseErrorWithinThisNamespace").runExpectingException(ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
    }

    @Test
    public void divisionByZero() throws Exception {
        this.flowRunner("divisionByZeroFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MULE", (String)"EXPRESSION"));
    }

    @Test
    public void heisenbergCureCancer() throws Exception {
        this.flowRunner("heisenbergCureCancerFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"HEISENBERG", (String)"HEALTH"));
    }

    @Test
    public void usingOperationRaiseError() throws Exception {
        this.flowRunner("usingOperationRaiseErrorFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
    }

    @Test
    public void errorMappingInInvocation() throws Exception {
        this.flowRunner("errorMappingOnInvocationFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED"));
    }

    @Test
    public void errorMappingInsideBody() throws Exception {
        this.flowRunner("errorMappingInsideBodyFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED"));
    }

    @Test
    public void errorMappingInsideBodyAndInInvocation() throws Exception {
        this.flowRunner("errorMappingInsideBodyAndInInvocationFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED_TWICE"));
    }

    @Test
    public void callingOperationThatSilencesErrors() throws Exception {
        this.flowRunner("flowCallingOperationThatSilencesOneSpecificErrorAndRaisesAnother").runExpectingException(ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
    }

    @Test
    public void executionExceptionHasTheCaughtErrorAsCause() throws Exception {
        try {
            this.flowRunner("flowCallingOperationThatSilencesOneSpecificErrorAndRaisesAnother").run();
            Assert.fail((String)"Calling the flow should have failed");
        }
        catch (EventProcessingException exception) {
            Optional optionalError = exception.getEvent().getError();
            Assert.assertThat((Object)optionalError.isPresent(), (Matcher)Matchers.is((Object)true));
            Error error = (Error)optionalError.get();
            Assert.assertThat((Object)error.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
            Throwable executionException = error.getCause();
            Assert.assertThat((Object)executionException, (Matcher)Matchers.instanceOf(ComponentExecutionException.class));
            Throwable causeAsException = executionException.getCause();
            Assert.assertThat((Object)causeAsException, (Matcher)Matchers.instanceOf(Error.class));
            Error causeAsError = (Error)causeAsException;
            Assert.assertThat((Object)causeAsError.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"HEISENBERG", (String)"HEALTH"));
        }
    }

    @Test
    public void reusableErrorHandlerAsAnOperation() throws Exception {
        CoreEvent result = this.flowRunner("reusableErrorHandlerAsAnOperationFlow").run();
        Assert.assertThat((Object)result, (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"Caught error!"))));
    }

    @Test
    public void errorMappingIsNotTransitive() throws Exception {
        this.flowRunner("transitiveMappingFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED"));
    }

    @Test
    public void mappingChildAfterParent() throws Exception {
        this.flowRunner("mappingChildAfterParentFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPEDCONNECTIVITY"));
    }

    @Test
    public void nestedTriesWithDefaultCauses() throws Exception {
        try {
            this.flowRunner("nestedErrorsFlow").run();
            Assert.fail((String)"Calling the flow should have failed");
        }
        catch (EventProcessingException exception) {
            Optional optionalError = exception.getEvent().getError();
            Assert.assertThat((Object)optionalError.isPresent(), (Matcher)Matchers.is((Object)true));
            Error error = (Error)optionalError.get();
            Assert.assertThat((Object)error.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"FOURTH"));
            Error causeOfFourth = MuleOperationErrorHandlingTestCase.getErrorCause(error);
            Assert.assertThat((Object)causeOfFourth, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)causeOfFourth.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"THIRD"));
            Error causeOfThird = MuleOperationErrorHandlingTestCase.getErrorCause(causeOfFourth);
            Assert.assertThat((Object)causeOfThird, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)causeOfThird.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"SECOND"));
            Error causeOfSecond = MuleOperationErrorHandlingTestCase.getErrorCause(causeOfThird);
            Assert.assertThat((Object)causeOfSecond, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)causeOfSecond.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"FIRST"));
            Throwable causeOfFirst = causeOfSecond.getCause();
            Assert.assertThat((Object)causeOfFirst, (Matcher)Matchers.instanceOf(DefaultMuleException.class));
        }
    }

    @Test
    public void operationReusingErrorHandlingLogic() throws Exception {
        this.flowRunner("reusableErrorHandlerAsAnOperationFlow").run();
    }

    @Test
    public void tryHandlingUnknownError() throws Exception {
        try {
            this.flowRunner("tryHandlingUnknownErrorFlow").run();
            Assert.fail((String)"Calling the flow should have failed");
        }
        catch (EventProcessingException exception) {
            Optional optionalError = exception.getEvent().getError();
            Assert.assertThat((Object)optionalError.isPresent(), (Matcher)Matchers.is((Object)true));
            Error error = (Error)optionalError.get();
            Assert.assertThat((Object)error.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"UNKNOWN"));
            Error cause = MuleOperationErrorHandlingTestCase.getErrorCause(error);
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)cause.getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
        }
    }

    private static Error getErrorCause(Error error) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        Throwable currentCause = error.getCause();
        while (!seen.contains(currentCause)) {
            seen.add(currentCause);
            if (currentCause instanceof Error) {
                return (Error)currentCause;
            }
            Assert.assertThat((Object)currentCause, (Matcher)Matchers.instanceOf(ComponentExecutionException.class));
            currentCause = currentCause.getCause();
        }
        return null;
    }

    @Test
    @Description(value="When an operation raises an error, the payload remains unchanged")
    public void whenAnOperationRaisesAnErrorThePayloadIsNotChanged() throws Exception {
        CoreEvent result = this.flowRunner("operationSettingPayloadAndRaisingErrorFlow").run();
        Assert.assertThat((Object)result, (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"Payload before calling the operation"))));
    }

    @Test
    @Description(value="This test is intended to avoid a change breaking backwards for the old behavior of flows (opposite to the operation's behavior)")
    public void whenAReferencedFlowChangesThePayloadAndRaisesAnErrorThePayloadIsChanged() throws Exception {
        CoreEvent result = this.flowRunner("backwardsCompatibleAwfulBehaviorFlow").run();
        Assert.assertThat((Object)result, (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"Payload set within the referenced flow"))));
    }
}

