/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Reuse")
@Stories(value={@Story(value="Application Extension Model"), @Story(value="Operations")})
@Issue(value="W-11989569")
public class MuleSdkDisabledTestCase
extends AbstractMuleSdkAstTestCase {
    @ClassRule
    public static SystemProperty disableMuleSdk = new SystemProperty("mule.experimental.enableMuleSdk", "false");

    @Override
    protected String getConfigFile() {
        return null;
    }

    @Override
    protected boolean validateSchema() {
        return true;
    }

    @Test
    public void whenMuleSdkIsDisabledThenAnOperationCanNotBeDefined() {
        ValidationResult validationResult = this.parseAstExpectingValidationErrors("validation/app-with-simple-operation.xml");
        this.assertErrorMessages(validationResult, "The component 'operation:def' doesn't belong to any extension model", "The component 'operation:output' doesn't belong to any extension model", "The component 'operation:payload-type' doesn't belong to any extension model", "The component 'operation:body' doesn't belong to any extension model");
        this.assertAllValidationsLevel(validationResult, Validation.Level.ERROR);
    }

    @Test
    public void whenMuleSdkIsDisabledTheNamespaceThisIsNotResolved() {
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.getArtifactAst("validation/app-using-namespace-this.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)"Can't resolve http://www.mulesoft.org/schema/mule/this/current/mule-this.xsd, A dependency or plugin might be missing"));
    }

    private void assertAllValidationsLevel(ValidationResult validationResult, Validation.Level expectedValidationLevel) {
        MatcherAssert.assertThat(validationResult.getItems().stream().map(ValidationResultItem::getValidation).map(Validation::getLevel).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)expectedValidationLevel)));
    }

    private void assertErrorMessages(ValidationResult validationResult, String ... messages) {
        MatcherAssert.assertThat(validationResult.getItems().stream().map(ValidationResultItem::getMessage).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])messages));
    }
}

