/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.validation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.mule.internal.validation.AbstractConfigFileValidationTestCase;

@Feature(value="Reuse")
@Stories(value={@Story(value="Operations"), @Story(value="Error Handling")})
public class NoReferencesToGlobalErrorHandlersValidationTestCase
extends AbstractConfigFileValidationTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    @Description(value="Error handlers within a reusable operation can't have references to global error handlers, neither use the default one, since it's also global")
    public void referenceToGlobalErrorHandler() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Error handlers within a reusable operation can't have references to global ones");
        this.parseConfig("validation/error-handler-referencing-global.xml");
    }

    @Test
    @Description(value="Error handler section can't have zero handlers")
    public void noErrorHandlersInTheErrorHandlerSection() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("The error handler section of a try within a reusable operation must have at least one error handler");
        this.parseConfig("validation/try-with-empty-error-handler.xml");
    }

    @Test
    @Description(value="A try without error handler section is implicitly referencing the default global error handler")
    public void implicitReferenceToDefaultErrorHandler() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Try scopes within a reusable operation can't use the default error handler because it's global. You have to specify an error handler.");
        this.parseConfig("validation/try-without-error-handler.xml");
    }
}

