/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.artifact.activation.internal.ast.ArtifactAstUtils;
import org.mule.runtime.module.artifact.activation.internal.ast.MuleSdkExtensionModelLoadingMediator;
import org.mule.runtime.module.artifact.activation.internal.ast.validation.AstValidationUtils;
import org.mule.runtime.module.extension.internal.loader.AbstractExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkPluginExtensionModelParserFactory;
import org.mule.runtime.module.extension.mule.internal.loader.parser.ast.MuleSdkPluginExtensionModelLoadingMediator;
import org.mule.runtime.module.extension.mule.internal.loader.parser.utils.MuleSdkExtensionLoadingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSdkPluginExtensionModelLoader
extends AbstractExtensionModelLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleSdkPluginExtensionModelParserFactory.class);
    private static final String MULE_SDK_EXTENSION_MODEL_PROPERTY_NAME = "_muleSdkArtifactExtensionModel";

    public String getId() {
        return "mule";
    }

    protected ExtensionModelParserFactory getExtensionModelParserFactory(ExtensionLoadingContext context) {
        return new MuleSdkPluginExtensionModelParserFactory();
    }

    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        super.configureContextBeforeDeclaration(context);
        Optional ast = context.getParameter("muleSDK.artifactAst");
        if (!ast.isPresent()) {
            context.addParameter("muleSDK.artifactAst", (Object)this.parseAstAndBuildPluginExtensionModel(context));
        }
    }

    protected ExtensionModel doCreate(ExtensionLoadingContext context) {
        return context.getParameter(MULE_SDK_EXTENSION_MODEL_PROPERTY_NAME).orElseGet(() -> super.doCreate(context));
    }

    private AstXmlParser createAstParser(Set<ExtensionModel> dependencies, boolean disableValidations) {
        AstXmlParser.Builder astBuilder = AstXmlParser.builder().withArtifactType(ArtifactType.MULE_EXTENSION).withExtensionModels(dependencies);
        if (disableValidations) {
            astBuilder.withSchemaValidationsDisabled();
        }
        return astBuilder.build();
    }

    private ArtifactAst parseAstAndBuildPluginExtensionModel(ExtensionLoadingContext context) {
        Set dependencies = context.getDslResolvingContext().getExtensions();
        ExpressionLanguageMetadataService expressionLanguageMetadataService = (ExpressionLanguageMetadataService)MuleSdkExtensionLoadingUtils.getRequiredLoadingParameter(context, "muleSDK.expressionLanguageMetadataService");
        String[] resources = new String[]{(String)MuleSdkExtensionLoadingUtils.getRequiredLoadingParameter(context, "muleSDK.resource")};
        String version = (String)MuleSdkExtensionLoadingUtils.getRequiredLoadingParameter(context, "version");
        MuleSdkPluginExtensionModelLoadingMediator loadingHelper = new MuleSdkPluginExtensionModelLoadingMediator(expressionLanguageMetadataService, context.getArtifactCoordinates(), version, (ExtensionModelLoader)this, em -> context.addParameter(MULE_SDK_EXTENSION_MODEL_PROPERTY_NAME, em));
        try {
            ArtifactAst artifactAst = ArtifactAstUtils.parseArtifact((String)context.getArtifactCoordinates().map(ArtifactCoordinates::getArtifactId).orElse(null), (Either)Either.left((Object)ArtifactAstUtils.loadConfigResources((String[])resources, (ClassLoader)context.getExtensionClassLoader())), this::createAstParser, (Set)dependencies, (boolean)false, (ClassLoader)context.getExtensionClassLoader(), (MuleSdkExtensionModelLoadingMediator)loadingHelper);
            AstValidationUtils.logWarningsAndThrowIfContainsErrors((ValidationResult)MuleAstUtils.validatorBuilder().build().validate(artifactAst), (Logger)LOGGER);
            return artifactAst;
        }
        catch (ConfigurationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

