/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.extension.ExtensionManager;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleOperationIsTransactionalTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private ExtensionManager extensionManager;
    private static List<OperationModel> operationModels;

    protected String getConfigFile() {
        return "mule-tx-ops-config.xml";
    }

    @Test
    @Description(value="Checks that operation without any tx is not transactional")
    public void withoutInnerTransactionalOps() {
        this.assertForOperation("withoutTxAction", false);
    }

    @Test
    @Description(value="Checks that operation with operation not joining is not transactional")
    public void withTxActionNotJoining() {
        this.assertForOperation("withTxActionNotJoining", false);
    }

    @Test
    @Description(value="Checks that operation with operation that joins tx is transactional")
    public void withTxActionJoining() {
        this.assertForOperation("withTxActionJoining", true);
    }

    @Test
    @Description(value="Checks that operation always joining tx is transactional")
    public void withTxActionAlwaysJoining() {
        this.assertForOperation("withTxActionAlwaysJoining", true);
    }

    @Test
    @Description(value="Checks that operation joining within try (indifferent) tx is transactional")
    public void withTxActionJoiningWithinTryIndifferent() {
        this.assertForOperation("withTxActionJoiningWithinTryIndifferent", true);
    }

    @Test
    @Description(value="Checks that operation not joining within try (indifferent) tx is not transactional")
    public void withTxActionNotJoiningWithinTryIndifferent() {
        this.assertForOperation("withTxActionNotJoiningWithinTryIndifferent", false);
    }

    @Test
    @Description(value="Checks that operation always joining within try (join) tx is transactional")
    public void withTxActionAlwaysJoiningWithinTryJoining() {
        this.assertForOperation("withTxActionAlwaysJoiningWithinTryJoining", true);
    }

    @Test
    @Description(value="Checks that operation not joining within try (joining) tx is not transactional")
    public void withTxActionNotJoiningWithinTryJoining() {
        this.assertForOperation("withTxActionNotJoiningWithinTryJoining", false);
    }

    @Test
    @Description(value="Checks that operation joining within try that creates tx is not transactional")
    public void withTxActionAlwaysJoiningWithinTryCreateTx() {
        this.assertForOperation("withTxActionAlwaysJoiningWithinTryCreateTx", false);
    }

    @Test
    @Description(value="Checks that operation not joining within try that creates tx is not transactional")
    public void withTxActionAlwaysNotJoiningWithinTryCreateTx() {
        this.assertForOperation("withTxActionAlwaysNotJoiningWithinTryCreateTx", false);
    }

    @Test
    @Description(value="Checks that operation joining within try that creates tx, followed by operation that joins is transactional")
    public void withTxActionAlwaysJoiningWithinTryCreateTxFollowed() {
        this.assertForOperation("withTxActionAlwaysJoiningWithinTryCreateTxFollowed", true);
    }

    @Test
    @Description(value="Checks that operation joining within try that creates tx, followed by operation that doesn't join is not transactional")
    public void withTxActionAlwaysJoiningWithinTryCreateTxFollowedNot() {
        this.assertForOperation("withTxActionAlwaysJoiningWithinTryCreateTxFollowedNot", false);
    }

    @Test
    @Description(value="Checks that operation not joining within async is not transactional")
    public void asyncWithNotSupported() {
        this.assertForOperation("asyncWithNotSupported", false);
    }

    @Test
    @Description(value="Checks that operation always joining within async is not transactional")
    public void asyncWithJoin() {
        this.assertForOperation("asyncWithJoin", false);
    }

    @Test
    @Description(value="Checks that operation joining within async is not transactional")
    public void asyncWithJoinIfPossible() {
        this.assertForOperation("asyncWithJoinIfPossible", false);
    }

    @Test
    @Description(value="Checks that operation not joining within async within try is not transactional")
    public void tryAndAsyncWithNotSupported() {
        this.assertForOperation("tryAndAsyncWithNotSupported", false);
    }

    @Test
    @Description(value="Checks that operation joining within async within try is not transactional")
    public void tryAndAsyncJoin() {
        this.assertForOperation("tryAndAsyncJoin", false);
    }

    @Test
    @Description(value="Checks that operation not joining within async within try, followed by not supported is not transactional")
    public void tryAndAsyncJoinFollowedByNotSupported() {
        this.assertForOperation("tryAndAsyncJoinFollowedByNotSupported", false);
    }

    @Test
    @Description(value="Checks that operation not joining within async within try, followed by join is transactional")
    public void tryAndAsyncJoinFollowedByJoin() {
        this.assertForOperation("tryAndAsyncJoinFollowedByJoin", true);
    }

    @Test
    @Description(value="Checks that operation not joining within async within try (join), followed by not supported is not transactional")
    public void tryAlwaysJoinAndAsyncJoinFollowedByJoin() {
        this.assertForOperation("tryAlwaysJoinAndAsyncJoinFollowedByJoin", false);
    }

    @Test
    @Description(value="Checks invoking a transactional operation makes this one transactional")
    public void callingOtherOp() {
        this.assertForOperation("callingOtherOp", true);
    }

    @Test
    @Description(value="Checks invoking a non transactional operation keeps this one as non transactional")
    public void callingOtherOpNonTx() {
        this.assertForOperation("callingOtherOpNonTx", false);
    }

    @Test
    @Description(value="Checks invoking a transactional operation within try that creates tx makes this one non transactional")
    public void callingOtherOpWithinTryWithTx() {
        this.assertForOperation("callingOtherOpWithinTryWithTx", false);
    }

    @Test
    @Description(value="Checks that choice with one route joining, makes the operation transactional")
    public void choiceWithOneRouteJoining() {
        this.assertForOperation("choice", true);
    }

    @Test
    @Description(value="Checks that an operation can have 'transactionalAction' parameter")
    public void havingTransactionalActionParameter() {
        OperationModel model = this.getOperationModel("operationWithTransactionalActionParameter");
        MatcherAssert.assertThat((Object)model.isTransactional(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)model.getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals("transactionalAction")), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertForOperation(String operation, boolean expectedIsTransactional) {
        OperationModel model = this.getOperationModel(operation);
        MatcherAssert.assertThat((Object)model.isTransactional(), (Matcher)CoreMatchers.is((Object)expectedIsTransactional));
        MatcherAssert.assertThat((Object)model.getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals("transactionalAction")), (Matcher)CoreMatchers.is((Object)false));
    }

    private OperationModel getOperationModel(String name) {
        if (operationModels == null) {
            operationModels = ((ExtensionModel)this.extensionManager.getExtension(muleContext.getConfiguration().getId()).get()).getOperationModels();
        }
        return operationModels.stream().filter(opModel -> opModel.getName().equals(name)).findFirst().get();
    }
}

