/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.function.HasFunctionModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.skyscreamer.jsonassert.JSONAssert;

@Feature(value="Reuse")
@Story(value="Application Extension Model")
public class ApplicationAsExtensionModelTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private ExtensionManager extensionManager;
    private ExtensionModelJsonSerializer serializer = new ExtensionModelJsonSerializer();

    protected String getConfigFile() {
        return "app-as-mule-extension.xml";
    }

    @Test
    public void loadApplicationExtensionModel() throws Exception {
        ExtensionModel extensionModel = this.getAppExtensionModel();
        String json = this.serializer.serialize(extensionModel);
        String expected = this.getResource("/models/app-as-mule-extension.json");
        try {
            JSONAssert.assertEquals((String)expected, (String)json, (boolean)true);
        }
        catch (AssertionError e) {
            System.out.println(json);
            throw e;
        }
    }

    @Test
    public void flowIsIgnored() {
        ExtensionModel extensionModel = this.getAppExtensionModel();
        new ExtensionWalker(){

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onConfiguration(ConfigurationModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }

            protected void onFunction(HasFunctionModels owner, FunctionModel model) {
                ApplicationAsExtensionModelTestCase.this.assertNotFlow((NamedObject)model);
            }
        }.walk(extensionModel);
    }

    private void assertNotFlow(NamedObject named) {
        Assert.assertThat((Object)named.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"superfluousFlow"))));
    }

    private ExtensionModel getAppExtensionModel() {
        return (ExtensionModel)this.extensionManager.getExtension(muleContext.getConfiguration().getId()).get();
    }

    private String getResource(String path) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        Preconditions.checkArgument((in != null ? 1 : 0) != 0, (String)("Resource not found: " + path));
        return IOUtils.toString((InputStream)in);
    }
}

