/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.StreamingStatistics;
import org.mule.runtime.module.extension.mule.internal.operation.FakeExpressionLanguageMetadataService;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.subtypes.extension.CarDoor;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleOperationOutputTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private StreamingManager streamingManager;

    protected void doTearDownAfterMuleContextDispose() {
        this.assertAllStreamingResourcesClosed();
    }

    protected String getConfigFile() {
        return "mule-operations-with-different-outputs-config.xml";
    }

    @Test
    @Description(value="Executes an operation with a set-payload, but with void output type, then the output payload is null")
    public void voidOutputOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("voidOutputOperationFlow").run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="Executes an operation with a set-payload and string output type, then the output payload is the string")
    public void stringOutputOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("stringOutputOperationFlow").run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"Expected output"));
    }

    @Test
    @Description(value="Executes an operation setting a repeatable stream output, but with void output type, then the output payload is null")
    public void withRepeatableStreamingAndVoidOutput() throws Exception {
        CoreEvent resultEvent = this.flowRunner("withRepeatableStreamingAndVoidOutputFlow").keepStreamsOpen().run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="Executes an operation setting a repeatable stream output, then the output payload is the stream")
    public void withRepeatableStreaming() throws Exception {
        CoreEvent resultEvent = this.flowRunner("withRepeatableStreamingFlow").keepStreamsOpen().run();
        Object cursorIteratorProvider = resultEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)cursorIteratorProvider, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CursorIteratorProvider.class)));
    }

    @Test
    @Description(value="An operation declaring an output payload type belonging to another extension")
    public void returningTypeFromDependency() throws Exception {
        CoreEvent resultEvent = this.flowRunner("returningDoorFlow").run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getDataType().getType(), (Matcher)CoreMatchers.is(CarDoor.class));
    }

    private void assertAllStreamingResourcesClosed() {
        if (this.streamingManager == null) {
            return;
        }
        StreamingStatistics stats = this.streamingManager.getStreamingStatistics();
        new PollingProber(10000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((String)"There are still open cursor providers", (Object)stats.getOpenCursorProvidersCount(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((String)"There are still open cursors", (Object)stats.getOpenCursorsCount(), (Matcher)CoreMatchers.is((Object)0));
            return true;
        }));
    }

    protected ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return new FakeExpressionLanguageMetadataService();
    }
}

