/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.module.extension.mule.internal.loader.ExtensionModelTestUtils;

@Feature(value="Reuse")
@Stories(value={@Story(value="Application Extension Model"), @Story(value="Error Handling")})
public class ErrorsInApplicationExtensionModelTestCase
extends MuleArtifactFunctionalTestCase {
    private static final Map<String, Set<String>> expectedErrors = new HashMap<String, Set<String>>();
    @Inject
    private ExtensionManager extensionManager;
    private ExtensionModel appExtensionModel;

    @BeforeClass
    public static void setupExpectedErrors() {
        expectedErrors.put("raiseThis", Collections.singleton("THIS:CUSTOM"));
        expectedErrors.put("raiseCustom", Collections.singleton("THIS:CUSTOM"));
        expectedErrors.put("heisenbergCureCancer", ExtensionModelTestUtils.asSet("HEISENBERG:HEALTH", "HEISENBERG:OAUTH2"));
        expectedErrors.put("withMappingInsideBody", ExtensionModelTestUtils.asSet("MY:MAPPED", "HEISENBERG:OAUTH2"));
        expectedErrors.put("mappingAnyInsideBody", Collections.singleton("MY:MAPPED"));
        expectedErrors.put("transitiveMapping", ExtensionModelTestUtils.asSet("MY:MAPPED", "HEISENBERG:OAUTH2"));
        expectedErrors.put("mappingChildAfterParent", Collections.singleton("MY:MAPPEDCONNECTIVITY"));
        expectedErrors.put("divisionByZero", Collections.emptySet());
        expectedErrors.put("operationSilencingOneSpecificErrorAndRaisingAnother", ExtensionModelTestUtils.asSet("HEISENBERG:OAUTH2", "THIS:CUSTOM"));
        expectedErrors.put("operationSilencingAllErrorsAndRaisingAnother", Collections.singleton("THIS:CUSTOM"));
        expectedErrors.put("operationSilencingAllHeisenbergErrorsAndRaisingAnother", Collections.singleton("THIS:HEALTH"));
        expectedErrors.put("operationSilencingAllHealthErrorsWithinACatchAll", Collections.singleton("HEISENBERG:OAUTH2"));
        expectedErrors.put("operationRaisingUniqueErrorAndCatchingIt", Collections.emptySet());
        expectedErrors.put("operationWithMultipleOnErrorContinues", Collections.emptySet());
        expectedErrors.put("operationCatchingAllButWithWhen", ExtensionModelTestUtils.asSet("HEISENBERG:OAUTH2", "HEISENBERG:HEALTH"));
    }

    protected String[] getConfigFiles() {
        return new String[]{"mule-error-handling-operations-config.xml", "mule-error-handling-with-try-operations-config.xml"};
    }

    @Before
    public void setUp() {
        this.appExtensionModel = this.getAppExtensionModel();
    }

    @Test
    public void appExtensionModelContainsRaisedErrors() {
        Set<String> raisedErrors = ExtensionModelTestUtils.getRaisedErrors(this.appExtensionModel);
        Assert.assertThat(raisedErrors, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"THIS:CONNECTIVITY", "MULE:ANY", "MULE:RETRY_EXHAUSTED", "THIS:RETRY_EXHAUSTED", "MULE:CONNECTIVITY", "HEISENBERG:HEALTH", "HEISENBERG:OAUTH2", "THIS:CUSTOM", "THIS:HEALTH", "THIS:UNIQUE", "MY:MAPPED", "MY:MAPPEDCONNECTIVITY", "THIS:FOURTH", "THIS:THIRD", "THIS:SECOND", "THIS:FIRST"}));
    }

    @Test
    public void eachOperationDeclaresTheErrorsThatRaises() {
        for (Map.Entry<String, Set<String>> expectedForOperation : expectedErrors.entrySet()) {
            String operationName = expectedForOperation.getKey();
            Set<String> expected = expectedForOperation.getValue();
            ExtensionModelTestUtils.assertRaisedErrors(this.appExtensionModel, operationName, expected);
        }
    }

    private ExtensionModel getAppExtensionModel() {
        return (ExtensionModel)this.extensionManager.getExtension(muleContext.getConfiguration().getId()).get();
    }
}

