/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.extension.mule.internal.loader.ExtensionModelTestUtils;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@Feature(value="Reuse")
@Stories(value={@Story(value="Extension Extension Model"), @Story(value="Error Handling")})
public class ErrorsInMuleSdkPluginExtensionModelTestCase
extends AbstractMuleSdkAstTestCase {
    private static final Map<String, Set<String>> expectedErrors = new HashMap<String, Set<String>>();

    @BeforeClass
    public static void setUp() {
        expectedErrors.put("raiseCustom", Collections.singleton("ERRORS:CUSTOM"));
        expectedErrors.put("raiseOther", Collections.singleton("ERRORS:OTHER"));
        expectedErrors.put("silencingOneAndRaisingOther", Collections.singleton("ERRORS:OTHER"));
        expectedErrors.put("heisenbergCureCancer", ExtensionModelTestUtils.asSet("HEISENBERG:HEALTH", "HEISENBERG:OAUTH2"));
        ErrorsInMuleSdkPluginExtensionModelTestCase.addDependencyExtension(ExtensionModelTestUtils.loadJavaSdkExtension(HeisenbergExtension.class, Collections.emptySet()));
    }

    @Override
    protected String getConfigFile() {
        return null;
    }

    @Test
    public void allErrorsOnExtensionModel() {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-with-errors.xml");
        Set<String> errorsAsString = ExtensionModelTestUtils.getRaisedErrors(extensionModel);
        MatcherAssert.assertThat(errorsAsString, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"MULE:ANY", "MULE:RETRY_EXHAUSTED", "ERRORS:CUSTOM", "ERRORS:CONNECTIVITY", "ERRORS:RETRY_EXHAUSTED", "MULE:CONNECTIVITY", "ERRORS:ONE", "ERRORS:OTHER", "HEISENBERG:HEALTH", "HEISENBERG:OAUTH2"}));
    }

    @Test
    public void eachOperationDeclaresTheErrorsThatRaises() {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-with-errors.xml");
        for (Map.Entry<String, Set<String>> expectedForOperation : expectedErrors.entrySet()) {
            String operationName = expectedForOperation.getKey();
            Set<String> expected = expectedForOperation.getValue();
            ExtensionModelTestUtils.assertRaisedErrors(extensionModel, operationName, expected);
        }
    }

    private ExtensionModel getExtensionModelFrom(String extensionFile) {
        return ExtensionModelTestUtils.loadMuleSdkExtension(extensionFile, ((Object)((Object)this)).getClass().getClassLoader(), astParserExtensionModels);
    }
}

