/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.construct;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.module.extension.mule.internal.construct.DefaultOperationBuilder;
import org.mule.runtime.module.extension.mule.internal.construct.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleOperation
extends AbstractComponent
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleOperation.class);
    private final List<Processor> processors;
    private final OperationModel operationModel;
    private final MuleContext muleContext;
    private MessageProcessorChain chain;
    private ProcessingStrategy processingStrategy;

    public static Operation.Builder builder() {
        return new DefaultOperationBuilder();
    }

    MuleOperation(List<Processor> processors, OperationModel operationModel, MuleContext muleContext) {
        this.processors = processors;
        this.operationModel = operationModel;
        this.muleContext = muleContext;
    }

    public CompletableFuture<ExecutionResult> execute(InputEvent inputEvent) {
        return this.chain.execute(inputEvent);
    }

    public CompletableFuture<Event> execute(Event event) {
        return this.chain.execute(event);
    }

    public void initialise() throws InitialisationException {
        try {
            this.processingStrategy = MessageProcessors.getDefaultProcessingStrategyFactory((MuleConfiguration)this.muleContext.getConfiguration()).create((ProfilingService)((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(InternalProfilingService.class), (FeatureFlaggingService)((MuleContextWithRegistry)this.muleContext).getRegistry().lookupObject(FeatureFlaggingService.class), this.muleContext.getSchedulerService(), () -> ((MuleContext)this.muleContext).getSchedulerBaseConfig(), this.operationModel.getName(), this.muleContext.getConfiguration().getId(), ArtifactType.valueOf((String)this.muleContext.getArtifactType().name()), () -> this.muleContext.getConfiguration().getShutdownTimeout());
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.processingStrategy);
        this.chain = MessageProcessors.newChain(Optional.ofNullable(this.processingStrategy), this.processors, (String)this.getLocation().getLocation(), null);
        LifecycleUtils.initialiseIfNeeded((Object)this.chain, (Injector)this.muleContext.getInjector());
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.processingStrategy);
        LifecycleUtils.startIfNeeded((Object)this.chain);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.chain);
        LifecycleUtils.stopIfNeeded((Object)this.processingStrategy);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.chain, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.processingStrategy, (Logger)LOGGER);
    }

    @Override
    public OperationModel getModel() {
        return this.operationModel;
    }
}

