/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.loader.parser.ConfigurationModelParser;
import org.mule.runtime.extension.api.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.FunctionModelParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.OperationModelParser;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.api.loader.parser.SourceModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityConnectionProviderModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityOperationModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivitySourceModelParser;
import org.mule.runtime.extension.ic.internal.runtime.configuration.ConnectivityConfigurationFactory;

public class ConnectivityConfigurationModelParser
implements ConfigurationModelParser {
    private final MuleConnectorSerializableModel muleConnectorSerializableModel;

    public ConnectivityConfigurationModelParser(MuleConnectorSerializableModel muleConnectorSerializableModel) {
        this.muleConnectorSerializableModel = muleConnectorSerializableModel;
    }

    public String getName() {
        return "config";
    }

    public String getDescription() {
        return "Default configuration";
    }

    public ConfigurationFactory getConfigurationFactory() {
        return new ConnectivityConfigurationFactory();
    }

    public boolean isForceNoImplicit() {
        return false;
    }

    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return List.of();
    }

    public List<ParameterGroupModelParser> getParameterGroupParsers() {
        return List.of();
    }

    public List<OperationModelParser> getOperationParsers() {
        return this.getOperationModelParsers(this.muleConnectorSerializableModel.getOperations());
    }

    public List<SourceModelParser> getSourceModelParsers() {
        return this.muleConnectorSerializableModel.getSources().stream().map(sourceModel -> new ConnectivitySourceModelParser(this.muleConnectorSerializableModel, (MuleSourceSerializableModel)sourceModel)).collect(Collectors.toList());
    }

    public List<ConnectionProviderModelParser> getConnectionProviderModelParsers() {
        return this.getConnectionProviderModelParsers(this.muleConnectorSerializableModel.getConnections());
    }

    public List<FunctionModelParser> getFunctionModelParsers() {
        return List.of();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(DisplayModel.builder().displayName("config").build());
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.empty();
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return List.of();
    }

    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return Optional.empty();
    }

    private List<OperationModelParser> getOperationModelParsers(List<MuleOperationSerializableModel> operations) {
        return operations.stream().map(operation -> new ConnectivityOperationModelParser(this.muleConnectorSerializableModel, (MuleOperationSerializableModel)operation, this.getExtensionName())).collect(Collectors.toList());
    }

    private List<ConnectionProviderModelParser> getConnectionProviderModelParsers(List<MuleConnectionProviderSerializableModel> muleConnectionProviderModelList) {
        return muleConnectionProviderModelList.stream().map(cpElement -> new ConnectivityConnectionProviderModelParser(this.muleConnectorSerializableModel, (MuleConnectionProviderSerializableModel)cpElement)).collect(Collectors.toList());
    }

    private String getExtensionName() {
        return this.muleConnectorSerializableModel.getName().toLowerCase();
    }
}

