/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthenticationType;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.ic.internal.runtime.connection.APIKeyConnectivityConnectionProvider;
import org.mule.runtime.extension.ic.internal.runtime.connection.BaseConnectivityConnectionProvider;
import org.mule.runtime.extension.ic.internal.runtime.connection.BasicConnectivityConnectionProvider;
import org.mule.runtime.extension.ic.internal.runtime.connection.BearerConnectivityConnectionProvider;
import org.mule.runtime.extension.ic.internal.runtime.connection.Connection;
import org.mule.runtime.extension.ic.internal.runtime.connection.OAuth2AuthorizationCodeConnectionProvider;
import org.mule.runtime.extension.ic.internal.runtime.connection.OAuth2ClientCredentialsConnectionProvider;

public class ConnectivityConnectionProviderFactory
implements ConnectionProviderFactory<Connection> {
    private final Class<? extends BaseConnectivityConnectionProvider> selectedProviderClass;
    private final Supplier<? extends BaseConnectivityConnectionProvider> selectedProvider;

    public ConnectivityConnectionProviderFactory(MuleConnectionProviderSerializableModel serializedProvider) {
        HttpAuthenticationType authenticationType = serializedProvider.getAuthenticationType();
        this.selectedProviderClass = switch (authenticationType.getType()) {
            case HttpAuthenticationType.Type.bearer -> BearerConnectivityConnectionProvider.class;
            case HttpAuthenticationType.Type.basic -> BasicConnectivityConnectionProvider.class;
            case HttpAuthenticationType.Type.apiKey -> APIKeyConnectivityConnectionProvider.class;
            case HttpAuthenticationType.Type.oauth2 -> this.getOAuth2ProviderClass(authenticationType);
            default -> throw new IllegalArgumentException("Unsupported authentication type: " + String.valueOf(authenticationType));
        };
        this.selectedProvider = switch (authenticationType.getType()) {
            case HttpAuthenticationType.Type.bearer -> () -> new BearerConnectivityConnectionProvider(serializedProvider);
            case HttpAuthenticationType.Type.basic -> () -> new BasicConnectivityConnectionProvider(serializedProvider);
            case HttpAuthenticationType.Type.apiKey -> () -> new APIKeyConnectivityConnectionProvider(serializedProvider);
            case HttpAuthenticationType.Type.oauth2 -> () -> this.getOAuth2Provider(authenticationType, serializedProvider);
            default -> throw new IllegalArgumentException("Unsupported authentication type: " + String.valueOf(authenticationType));
        };
    }

    public BaseConnectivityConnectionProvider newInstance() {
        return this.selectedProvider.get();
    }

    public Class<? extends BaseConnectivityConnectionProvider> getObjectType() {
        return this.selectedProviderClass;
    }

    private Class<? extends BaseConnectivityConnectionProvider> getOAuth2ProviderClass(HttpAuthenticationType httpAuthType) {
        OAuth2AuthenticationType.GrantType grantType = this.getGrantType(httpAuthType);
        return switch (grantType) {
            default -> throw new IncompatibleClassChangeError();
            case OAuth2AuthenticationType.GrantType.authorizationCode -> OAuth2AuthorizationCodeConnectionProvider.class;
            case OAuth2AuthenticationType.GrantType.clientCredentials -> OAuth2ClientCredentialsConnectionProvider.class;
        };
    }

    private BaseConnectivityConnectionProvider getOAuth2Provider(HttpAuthenticationType httpAuthType, MuleConnectionProviderSerializableModel serializedProvider) {
        OAuth2AuthenticationType.GrantType grantType = this.getGrantType(httpAuthType);
        return switch (grantType) {
            default -> throw new IncompatibleClassChangeError();
            case OAuth2AuthenticationType.GrantType.authorizationCode -> new OAuth2AuthorizationCodeConnectionProvider(serializedProvider);
            case OAuth2AuthenticationType.GrantType.clientCredentials -> new OAuth2ClientCredentialsConnectionProvider(serializedProvider);
        };
    }

    private OAuth2AuthenticationType.GrantType getGrantType(HttpAuthenticationType httpAuthType) {
        Optional subType = httpAuthType.getSubType();
        if (subType.isPresent()) {
            return OAuth2AuthenticationType.GrantType.fromString((String)((String)subType.get()));
        }
        throw new IllegalArgumentException("SubType cannot be null for OAuth authentication");
    }
}

