/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityParameterModelParser;
import org.mule.runtime.extension.ic.internal.parser.ParameterGroupModelParserWithDefaults;
import org.mule.runtime.extension.ic.internal.parser.ProxyParser;
import org.mule.runtime.extension.ic.internal.parser.TlsParser;
import org.mule.runtime.extension.ic.internal.parser.utils.AnnotationUtils;

public class ConnectivityParameterGroupParser
implements ParameterGroupModelParserWithDefaults {
    private final MetadataType inputMetadataType;
    private final Set<TypeAnnotation> annotations;
    private final String parameterGroupName;
    private final List<String> paramsToOmit;
    private final boolean isConnectionProvider;
    private final MuleConnectorSerializableModel muleConnectorSerializableModel;
    private final Map<SerializedObjectFieldSelector, SerializedProviderReferences> inputResolvedProviders;

    public ConnectivityParameterGroupParser(MuleConnectorSerializableModel muleConnectorSerializableModel, MetadataType metadataType, Map<SerializedObjectFieldSelector, SerializedProviderReferences> inputResolvedProviders, String parameterGroupName, boolean isConnectionProvider, List<String> paramsToOmit) {
        this.muleConnectorSerializableModel = muleConnectorSerializableModel;
        this.inputMetadataType = metadataType;
        this.inputResolvedProviders = inputResolvedProviders;
        this.annotations = this.inputMetadataType.getAnnotations();
        this.parameterGroupName = parameterGroupName;
        this.isConnectionProvider = isConnectionProvider;
        this.paramsToOmit = paramsToOmit;
    }

    public String getName() {
        return this.parameterGroupName;
    }

    public String getDescription() {
        return "";
    }

    public List<ParameterModelParser> getParameterParsers() {
        ArrayList<ParameterModelParser> parsers = new ArrayList<ParameterModelParser>();
        if (this.inputMetadataType instanceof ObjectType) {
            parsers.addAll(((ObjectType)this.inputMetadataType).getFields().stream().filter(param -> !this.paramsToOmit.contains(param.getKey().getName().getLocalPart())).map(param -> new ConnectivityParameterModelParser((ObjectFieldType)param, this.getValueProviderModel((ObjectFieldType)param), this.fetchProviderReferences((ObjectFieldType)param))).toList());
        }
        if (this.isConnectionProvider) {
            parsers.add(new TlsParser());
            parsers.add(new ProxyParser());
        }
        return parsers;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.of(DisplayModel.builder().displayName(AnnotationUtils.findAnnotation(this.annotations, LabelAnnotation.class).map(LabelAnnotation::getValue).orElse("")).build());
    }

    private MuleValueProviderSerializableModel getValueProviderModel(ObjectFieldType param) {
        String valueProviderReference = this.getValueProviderReference(this.fetchProviderReferences(param));
        if (valueProviderReference.isEmpty()) {
            return null;
        }
        return this.muleConnectorSerializableModel.getValueProvider(valueProviderReference);
    }

    private SerializedProviderReferences fetchProviderReferences(ObjectFieldType field) {
        for (SerializedObjectFieldSelector selector : this.inputResolvedProviders.keySet()) {
            if (!selector.getPath()[0].equals(field.getKey().getName().getLocalPart())) continue;
            return this.inputResolvedProviders.get(selector);
        }
        return null;
    }

    public String getValueProviderReference(SerializedProviderReferences providerReferences) {
        return providerReferences != null && providerReferences.getValueProviderReference() != null ? providerReferences.getValueProviderReference().getName() : "";
    }
}

