/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.utils;

import com.mulesoft.connectivity.mule.api.Content;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.metadata.MediaType;

public class ContentExtractorUtils {
    private ContentExtractorUtils() {
    }

    public static InputStream getRawValue(Content content) {
        return (InputStream)content.getRawValue().orElseThrow(() -> new RuntimeException("Content is empty"));
    }

    public static Map<String, Object> getOutputAttributes(Content content) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map transportAttributes = content.getTransportAttributes().orElseGet(Collections::emptyMap);
        attributes.put("statusCode", transportAttributes.get("statusCode"));
        return attributes;
    }

    public static MediaType getMediaType(Content content) {
        return content.getContentType().filter(contentType -> !contentType.isBlank()).map(MediaType::parse).orElse(MediaType.APPLICATION_JSON);
    }
}

